<?php
	//----------------------------------------------------------------------------
	// Skapar en "tumnagel" (förminskad kopia) utifrån en bild
	// OBS! skriver över ev. befintlig fil med samma sökväg som $resized_file
	// Returnerar true om allt går bra, annars die()
	//----------------------------------------------------------------------------
	function create_resized_image($source_file, $resized_file, $width, $height)
	{
		//läser in originalbildens bild-dimensioner+bildtyp och räknar ut "tumnagelns" storlek
		list($source_width, $source_height, $imagetype) = getimagesize($source_file);
		$ratio = ($source_width / $source_height);
		if ( ($width / $height) > $ratio )
		{
			//stående porträtt
			$width = intval($height * $ratio);
		}
		else
		{
			//liggande landskap
			$height = intval($width / $ratio);
		}

		//läser in originalbilden (JPG, PNG eller GIF)
		if ( $imagetype == IMAGETYPE_JPEG )
		{
			$source = imagecreatefromjpeg($source_file);
		}
		elseif ( $imagetype == IMAGETYPE_PNG )
		{
			$source = imagecreatefrompng($source_file);
		}
		elseif ( $imagetype == IMAGETYPE_GIF )
		{
			$source = imagecreatefromgif($source_file);
		}
		else
		{
			die('error: OptiAdmin::resize_image(): bildformatet stöds ej');
		}

		//skapar den nya "tumnageln"
		$resized = imagecreatetruecolor($width, $height);

		//ändra storlek
		if ( !imagecopyresampled($resized, $source, 0, 0, 0, 0, $width, $height, $source_width, $source_height) )
		{
			die('error: OptiAdmin::resize_image(): kunde inte ändra storlek på bilden');
		}

		//sparar "tumnageln" (JPG, PNG eller GIF)
		if ( $imagetype == IMAGETYPE_JPEG )
		{
			$result = imagejpeg($resized, $resized_file, 90);
		}
		elseif ( $imagetype == IMAGETYPE_PNG )
		{
			$result = imagepng($resized, $resized_file);
		}
		elseif ( $imagetype == IMAGETYPE_GIF )
		{
			$result = imagegif($resized, $resized_file);
		}

		if ( $result )
		{
			return true;
		}
		else
		{
			die('error: OptiAdmin::resize_image(): kunde inte spara filen');
		}
}

// resize
/*  

kolla max bredden 300
kolla förhållanden 3*4
cropa bilden om den är fel stor lek

spar nya storleken som borde vara 300 x 400



*/
function  GetImgSufix($source_file){
	  list($source_width, $source_height, $imagetype) = getimagesize($source_file);
		if ( $imagetype == IMAGETYPE_JPEG )
		{
			$sufix = ".jpg";
		}
		elseif ( $imagetype == IMAGETYPE_PNG )
		{
			$sufix = ".png";
		}
		elseif ( $imagetype == IMAGETYPE_GIF )
		{
			$sufix = ".gif";
		}
		else
		{
			die('error: OptiAdmin::resize_image(): bildformatet stöds ej');
		}

		return $sufix;

}




//------------------------------------------------------------------------------
// Cropp image från förhållanden
//------------------------------------------------------------------------------

function crop_image($source_file, $resized_file){
	 
    list($source_width, $source_height, $imagetype) = getimagesize($source_file);

    $ratio = ($source_width / $source_height);
   

    //echo "Ratio: ",$ratio,"<br>";
    //echo round(4.8,0);

    if ($ratio > 0.75){
      // vi skall utgå från höjden
      $newheight = $source_height;
      //$newwidth = round($source_height*0.75, 0);
      $newwidth = round($source_height*1.3333333333333333, 0);
      $offsetx = round(($source_width-$newwidth)/2,0);
      $offsety = 0;
    
    }else{

      // vi skall utgå från bredden
      //$newheight = round($source_width*1.3333333333333333, 0);
      $newheight = round($source_width*0.75, 0);

      $newwidth = $source_width;
      $offsetx = 0;
      $offsety = round(($source_height-$newheight)/2,0);;
    }

     /*
    echo "new height:",$newheight,"<br>";
    echo "new width:",$newwidth,"<br>";
    echo "OffsetX:",$offsetx,"<br>";
    echo "OffsetY:",$offsety,"<br>";
    echo "resized_file:",$resized_file,"<br>";
    */
    
   

	//läser in originalbilden (JPG, PNG eller GIF)
		if ( $imagetype == IMAGETYPE_JPEG )
		{
			$source = imagecreatefromjpeg($source_file);
		}
		elseif ( $imagetype == IMAGETYPE_PNG )
		{
			$source = imagecreatefrompng($source_file);
		}
		elseif ( $imagetype == IMAGETYPE_GIF )
		{
			$source = imagecreatefromgif($source_file);
		}
		else
		{
			die('error: OptiAdmin::resize_image(): bildformatet stöds ej----');
		}
	

		//skapar den nya "tumnageln"
		$resized = imagecreatetruecolor($newwidth, $newheight);

		//ändra storlek
		if ( !imagecopyresampled($resized, $source, 0, 0, $offsetx, $offsety, $newwidth, $newheight, $newwidth, $newheight) )
		{
			die('error: OptiAdmin::resize_image(): kunde inte ändra storlek på bilden');
		}

		//sparar "tumnageln" (JPG, PNG eller GIF)
		if ( $imagetype == IMAGETYPE_JPEG )
		{
			$result = imagejpeg($resized, $resized_file, 100);
		}
		elseif ( $imagetype == IMAGETYPE_PNG )
		{
			$result = imagepng($resized, $resized_file);
		}
		elseif ( $imagetype == IMAGETYPE_GIF )
		{
			$result = imagegif($resized, $resized_file);
		}

		if ( $result )
		{
			return true;
		}
		else
		{
			die('error: OptiAdmin::resize_image(): kunde inte spara filen');
		}

}


?>