<?php
//------------------------------------------------------------------------------
// OptiAdmin
//------------------------------------------------------------------------------

//gör inställningar och definierar konstanter
define('OPTIADMIN_VERSION', '3.0c'); /*.*/
define('SUFFIX_UPLOADED_FILE', '_uploaded_file');
$root_path = './';
error_reporting(E_ALL);
ini_set('log_errors', '1');
ini_set('display_errors', '1');
ini_set('error_log', 'error.log');
mb_internal_encoding('UTF-8');

//inkluderar externa php-filer
require($root_path.'includes/functions.php');
require($root_path.'includes/class_optiadmin.php');
require($root_path.'includes/class_template.php');
require($root_path.'includes/config.php');
require($root_path.'includes/mysql.php');						//kopplar upp mot databasen



//definierar giltiga värden för MODULE och ACTION
$actions_per_module = array(
	'index' => array('index', 'login', 'logout', 'settings', 'add_user', 'save_setting', 'delete_setting', 'sort_table', 'view_geoposition', 'edit_geoposition'),
	'paroc_users' => array(
		'list', 'view', 'add', 'edit', 'save', 'delete', 'copy', 'export',
	),
	'products' => array(
		'list', 'view', 'add', 'edit', 'save', 'delete', 'copy', 'export',
	),
	'protocol' => array(
		'list', 'view', 'add', 'edit', 'save', 'delete', 'copy', 'export',
		'multi_view', 'multi_list', 'multi_add', 'multi_edit', 'multi_save', 'multi_delete',
	),
	'surfaces' => array(
		'list', 'view', 'add', 'edit', 'save', 'delete', 'copy', 'export',
	),
);
//hämtar MODULE (nollställer $module om $module är otillåten)
$module = ( isset($_GET['module']) ) ? $_GET['module'] : NULL;
if ( !array_key_exists($module, $actions_per_module) )
{
	$module = 'index';
}
//hämtar ACTION (nollställer både $module och $action om $action är otillåten)
$action = ( isset($_GET['action']) ) ? $_GET['action'] : NULL;
if ( !in_array($action, $actions_per_module[$module]) )
{
	$module = 'index';
	$action = 'index';
}

//hämtar SPRÅK och inkluderar språk-fil (skapar $lang-variabel)
$language = 'sv';
include($root_path.'includes/lang_'.$language.'.php');

//om användaren vill LOGGA IN: visa inloggningsformuläret
if ( $module == 'index' && $action == 'login' )
{
	require($root_path.'templates_'.$language.'/index_login.tpl');
	die();
}

//skapar ANVÄNDARE (dör och redirectar till inloggningsformuläret om vi inte har en inloggad användare)
$user = new OptiUser();

//om användaren vill LOGGA UT: logga ut
if ( $module == 'index' && $action == 'logout' )
{
	$user->logout();
	die();
}



//------------------------------------------------------------------------------
// PHP innan header (t.ex. Ajax, ?action=save)
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
// AJAX: Multi-Save (innan header)
//------------------------------------------------------------------------------
if ( $action == 'multi_save' )
{
	$id = ( isset($_GET['id']) ) ? $_GET['id'] : 0;
	$multi = ( isset($_GET['multi']) ) ? $_GET['multi'] : NULL;
	$multi_id = ( isset($_POST['multi_id']) ) ? intval($_POST['multi_id']) : 0;		//(0 = nytt, 1+ = gammalt)

	//----------------------------------------------------------------------------
	// Protokoll:multi:ytor
	if ( $module == 'protocol' && $multi == 'ytor' )
	{
		$protocol = new ProtocolRow();
		$protocol->id_from_get();

		//hämta och rengör data från POST
		$typ_id = OptiAdmin::clean('int', 'typ_id');
		$best_yta = OptiAdmin::clean('float', 'best_yta');
		$best_tjocklek = OptiAdmin::clean('float', 'best_tjocklek');
		$ytan = OptiAdmin::clean('float', 'ytan');
		$tjocklek = OptiAdmin::clean('float', 'tjocklek');
		$produkt_namn = OptiAdmin::clean('text', 'produkt_namn');
		$sackvikt = OptiAdmin::clean('float', 'sackvikt');
		$sattning = OptiAdmin::clean('float', 'sattning');
		$min_densitet = OptiAdmin::clean('float', 'min_densitet');
		$line_catalog_desc = OptiAdmin::clean('text', 'line_catalog_desc');
		$line_vendor_no = OptiAdmin::clean('text', 'line_vendor_no');
		$line_area_and_size = OptiAdmin::clean('text', 'line_area_and_size');
		$antal_sack_verklig = OptiAdmin::clean('int', 'antal_sack_verklig');
		$antal_sack_beraknad = OptiAdmin::clean('int', 'antal_sack_beraknad');
		$lambda = OptiAdmin::clean('float', 'lambda');
		$isparocprodukt = OptiAdmin::clean('bool', 'isparocprodukt');
		$sack_kubik = OptiAdmin::clean('float', 'sack_kubik');
		$active = OptiAdmin::clean('bool', 'active');

		//förbered MySQL-queryn
		$sql_set = "typ_id = $typ_id,
		best_yta = $best_yta,
		best_tjocklek = $best_tjocklek,
		ytan = $ytan,
		tjocklek = $tjocklek,
		produkt_namn = '$produkt_namn',
		sackvikt = $sackvikt,
		sattning = $sattning,
		min_densitet = $min_densitet,
		line_catalog_desc = '$line_catalog_desc',
		line_vendor_no = '$line_vendor_no',
		line_area_and_size = '$line_area_and_size',
		antal_sack_verklig = $antal_sack_verklig,
		antal_sack_beraknad = $antal_sack_beraknad,
		lambda = $lambda,
		isparocprodukt = '$isparocprodukt',
		sack_kubik = $sack_kubik,
		active = '$active'";

		//sparar (skapar/uppdaterar)
		$protocol->multi_ytor_save($multi_id, $sql_set);
	}


	//stäng iframe-lightbox-rutan
	$tpl = new Template('templates_'.$language);
	$tpl->set_filenames(array('header' => 'header_iframe.tpl'));
	$tpl->assign_vars(array(
		'BASE_FILENAME' => $cfg->admin_base_filename,
	));
	$tpl->pparse('header');

	echo "<script type='text/javascript'>
	parent.window.hs.getExpander().close();
	parent.window.load_ajax('multi_".$multi."', '?module=".$module."&action=multi_list&multi=".$multi."&id=".$id."');
</script>";

	include($root_path.'templates_'.$language.'/footer_iframe.tpl');
	die();
}
//------------------------------------------------------------------------------
// AJAX: Multi-Delete AJAX (innan header)
//------------------------------------------------------------------------------
if ( $action == 'multi_delete' )
{
	$multi = ( isset($_GET['multi']) ) ? $_GET['multi'] : NULL;
	$multi_id = ( isset($_GET['multi_id']) ) ? intval($_GET['multi_id']) : NULL;

	//----------------------------------------------------------------------------
	// Protokoll:multi:ytor
	if ( $module == 'protocol' && $multi == 'ytor' )
	{
		$protocol = new ProtocolRow();
		$protocol->id_from_get();

		//tar bort
		$protocol->multi_ytor_delete($multi_id);
		echo '<div class="feedback_success"><p>'.$lang->borttagen.'</p></div>';
	}

	//kör multi_list
	$action = 'multi_list';
}
//------------------------------------------------------------------------------
// iFrame: Multi-Add (innan header)
//------------------------------------------------------------------------------
if ( $action == 'multi_add' )
{
	$tpl = new Template('templates_'.$language);
	$tpl->set_filenames(array('header' => 'header_iframe.tpl'));
	//ladda TinyMCE
	$tpl->assign_block_vars('tinymce', array());
	$tpl->assign_vars(array(
		'BASE_FILENAME' => $cfg->admin_base_filename,
	));
	$tpl->pparse('header');
	$tpl->set_filenames(array('iframe' => $module.'_multi_add.tpl'));

	$multi = ( isset($_GET['multi']) ) ? $_GET['multi'] : NULL;
	$multi_id = ( isset($_GET['multi_id']) ) ? intval($_GET['multi_id']) : NULL;

	//----------------------------------------------------------------------------
	// Protokoll:multi:ytor
	if ( $module == 'protocol' && $multi == 'ytor' )
	{
		$protocol = new ProtocolRow();
		$protocol->id_from_get();

		//skriv ut modulens id
		$tpl->assign_vars(array(
			'ID' => $protocol->id,
		));

		$tpl->assign_block_vars('ytor', array(
			'INPUT_TYP_ID' => OptiAdmin::edit('int', NULL, 'typ_id'),
			'INPUT_BEST_YTA' => OptiAdmin::edit('float', NULL, 'best_yta'),
			'INPUT_BEST_TJOCKLEK' => OptiAdmin::edit('float', NULL, 'best_tjocklek'),
			'INPUT_YTAN' => OptiAdmin::edit('float', NULL, 'ytan'),
			'INPUT_TJOCKLEK' => OptiAdmin::edit('float', NULL, 'tjocklek'),
			'INPUT_PRODUKT_NAMN' => OptiAdmin::edit('text', NULL, 'produkt_namn'),
			'INPUT_SACKVIKT' => OptiAdmin::edit('float', NULL, 'sackvikt'),
			'INPUT_SATTNING' => OptiAdmin::edit('float', NULL, 'sattning'),
			'INPUT_MIN_DENSITET' => OptiAdmin::edit('float', NULL, 'min_densitet'),
			'INPUT_LINE_CATALOG_DESC' => OptiAdmin::edit('text', NULL, 'line_catalog_desc'),
			'INPUT_LINE_VENDOR_NO' => OptiAdmin::edit('text', NULL, 'line_vendor_no'),
			'INPUT_LINE_AREA_AND_SIZE' => OptiAdmin::edit('text', NULL, 'line_area_and_size'),
			'INPUT_ANTAL_SACK_VERKLIG' => OptiAdmin::edit('int', NULL, 'antal_sack_verklig'),
			'INPUT_ANTAL_SACK_BERAKNAD' => OptiAdmin::edit('int', NULL, 'antal_sack_beraknad'),
			'INPUT_LAMBDA' => OptiAdmin::edit('float', NULL, 'lambda'),
			'INPUT_ISPAROCPRODUKT' => OptiAdmin::edit('bool', NULL, 'isparocprodukt'),
			'INPUT_SACK_KUBIK' => OptiAdmin::edit('float', NULL, 'sack_kubik'),
			'INPUT_ACTIVE' => OptiAdmin::edit('bool', NULL, 'active'),
		));
	}

	$tpl->pparse('iframe');
	include($root_path.'templates_'.$language.'/footer_iframe.tpl');
	die();
}
//------------------------------------------------------------------------------
// iFrame: Multi-Edit (innan header)
//------------------------------------------------------------------------------
if ( $action == 'multi_edit' )
{
	$tpl = new Template('templates_'.$language);
	$tpl->set_filenames(array('header' => 'header_iframe.tpl'));
	//ladda TinyMCE
	$tpl->assign_block_vars('tinymce', array());
	$tpl->assign_vars(array(
		'BASE_FILENAME' => $cfg->admin_base_filename,
	));
	$tpl->pparse('header');
	$tpl->set_filenames(array('iframe' => $module.'_multi_edit.tpl'));

	$multi = ( isset($_GET['multi']) ) ? $_GET['multi'] : NULL;
	$multi_id = ( isset($_GET['multi_id']) ) ? intval($_GET['multi_id']) : NULL;

	//----------------------------------------------------------------------------
	// Protokoll:multi:ytor
	if ( $module == 'protocol' && $multi == 'ytor' )
	{
		$protocol = new ProtocolRow();
		$protocol->id_from_get();
		$protocol->multi_ytor_load($multi_id);

		//skriv ut modulens id
		$tpl->assign_vars(array(
			'ID' => $protocol->id,
		));

		$r = $protocol->multi_rows[$multi_id];
		$tpl->assign_block_vars('ytor', array(
			'ID' => $multi_id,
			'INPUT_TYP_ID' => OptiAdmin::edit('int', $r['typ_id'], 'typ_id'),
			'INPUT_BEST_YTA' => OptiAdmin::edit('float', $r['best_yta'], 'best_yta'),
			'INPUT_BEST_TJOCKLEK' => OptiAdmin::edit('float', $r['best_tjocklek'], 'best_tjocklek'),
			'INPUT_YTAN' => OptiAdmin::edit('float', $r['ytan'], 'ytan'),
			'INPUT_TJOCKLEK' => OptiAdmin::edit('float', $r['tjocklek'], 'tjocklek'),
			'INPUT_PRODUKT_NAMN' => OptiAdmin::edit('text', $r['produkt_namn'], 'produkt_namn'),
			'INPUT_SACKVIKT' => OptiAdmin::edit('float', $r['sackvikt'], 'sackvikt'),
			'INPUT_SATTNING' => OptiAdmin::edit('float', $r['sattning'], 'sattning'),
			'INPUT_MIN_DENSITET' => OptiAdmin::edit('float', $r['min_densitet'], 'min_densitet'),
			'INPUT_LINE_CATALOG_DESC' => OptiAdmin::edit('text', $r['line_catalog_desc'], 'line_catalog_desc'),
			'INPUT_LINE_VENDOR_NO' => OptiAdmin::edit('text', $r['line_vendor_no'], 'line_vendor_no'),
			'INPUT_LINE_AREA_AND_SIZE' => OptiAdmin::edit('text', $r['line_area_and_size'], 'line_area_and_size'),
			'INPUT_ANTAL_SACK_VERKLIG' => OptiAdmin::edit('int', $r['antal_sack_verklig'], 'antal_sack_verklig'),
			'INPUT_ANTAL_SACK_BERAKNAD' => OptiAdmin::edit('int', $r['antal_sack_beraknad'], 'antal_sack_beraknad'),
			'INPUT_LAMBDA' => OptiAdmin::edit('float', $r['lambda'], 'lambda'),
			'INPUT_ISPAROCPRODUKT' => OptiAdmin::edit('bool', $r['isparocprodukt'], 'isparocprodukt'),
			'INPUT_SACK_KUBIK' => OptiAdmin::edit('float', $r['sack_kubik'], 'sack_kubik'),
			'INPUT_ACTIVE' => OptiAdmin::edit('bool', $r['active'], 'active'),
		));
		unset($r);
	}

	$tpl->pparse('iframe');
	include($root_path.'templates_'.$language.'/footer_iframe.tpl');
	die();
}
//------------------------------------------------------------------------------
// AJAX: Multi-List (innan header)
//------------------------------------------------------------------------------
if ( $action == 'multi_list' )
{
	$tpl = new Template('templates_'.$language);
	$tpl->set_filenames(array('ajax' => $module.'_multi_list.tpl'));

	$multi = ( isset($_GET['multi']) ) ? $_GET['multi'] : NULL;

	//----------------------------------------------------------------------------
	// Protokoll:multi:ytor
	if ( $module == 'protocol' && $multi == 'ytor' )
	{
		$protocol = new ProtocolRow();
		$protocol->id_from_get();
		$protocol->multi_ytor_load();

		//skriv ut modulens id
		$tpl->assign_vars(array(
			'BASE_FILENAME' => $cfg->admin_base_filename,
			'ID' => $protocol->id,
		));

		if ( count($protocol->multi_rows) > 0 )
		{
			$tpl->assign_block_vars('ytor', array());
			foreach ($protocol->multi_rows as $r)
			{
				$row_class = ( isset($row_class) && $row_class == 'row1' ) ? 'row2' : 'row1';
				$tpl->assign_block_vars('ytor.row', array(
					'ROW_CLASS' => $row_class,
					'ID' => intval($r['id']),
					'TYP_ID' => OptiAdmin::view('int', $r['typ_id'], 'typ_id'),
					'BEST_YTA' => OptiAdmin::view('float', $r['best_yta'], 'best_yta'),
					'BEST_TJOCKLEK' => OptiAdmin::view('float', $r['best_tjocklek'], 'best_tjocklek'),
					'YTAN' => OptiAdmin::view('float', $r['ytan'], 'ytan'),
					'TJOCKLEK' => OptiAdmin::view('float', $r['tjocklek'], 'tjocklek'),
					'PRODUKT_NAMN' => OptiAdmin::view('text', $r['produkt_namn'], 'produkt_namn'),
					'SACKVIKT' => OptiAdmin::view('float', $r['sackvikt'], 'sackvikt'),
					'SATTNING' => OptiAdmin::view('float', $r['sattning'], 'sattning'),
					'MIN_DENSITET' => OptiAdmin::view('float', $r['min_densitet'], 'min_densitet'),
					'LINE_CATALOG_DESC' => OptiAdmin::view('text', $r['line_catalog_desc'], 'line_catalog_desc'),
					'LINE_VENDOR_NO' => OptiAdmin::view('text', $r['line_vendor_no'], 'line_vendor_no'),
					'LINE_AREA_AND_SIZE' => OptiAdmin::view('text', $r['line_area_and_size'], 'line_area_and_size'),
					'ANTAL_SACK_VERKLIG' => OptiAdmin::view('int', $r['antal_sack_verklig'], 'antal_sack_verklig'),
					'ANTAL_SACK_BERAKNAD' => OptiAdmin::view('int', $r['antal_sack_beraknad'], 'antal_sack_beraknad'),
					'LAMBDA' => OptiAdmin::view('float', $r['lambda'], 'lambda'),
					'ISPAROCPRODUKT' => OptiAdmin::view('bool', $r['isparocprodukt'], 'isparocprodukt'),
					'SACK_KUBIK' => OptiAdmin::view('float', $r['sack_kubik'], 'sack_kubik'),
					'ACTIVE' => OptiAdmin::view('bool', $r['active'], 'active'),
				));
			}
			unset($r);
		}
		else
		{
			echo '<p><em>'.$lang->no_result.'</em></p>';
		}

		//skriv ut add new
		$tpl->assign_block_vars('ytor_add', array());
	}

	$tpl->pparse('ajax');
	die();
}
//------------------------------------------------------------------------------
// AJAX: Multi-View (innan header)
//------------------------------------------------------------------------------
if ( $action == 'multi_view' )
{
	$tpl = new Template('templates_'.$language);
	$tpl->set_filenames(array('ajax' => $module.'_multi_view.tpl'));

	$multi = ( isset($_GET['multi']) ) ? $_GET['multi'] : NULL;

	//----------------------------------------------------------------------------
	// Protokoll:multi:ytor
	if ( $module == 'protocol' && $multi == 'ytor' )
	{
		$protocol = new ProtocolRow();
		$protocol->id_from_get();
		$protocol->multi_ytor_load();

		if ( count($protocol->multi_rows) > 0 )
		{
			$tpl->assign_block_vars('ytor', array());
			foreach ($protocol->multi_rows as $r)
			{
				$row_class = ( isset($row_class) && $row_class == 'row1' ) ? 'row2' : 'row1';
				$tpl->assign_block_vars('ytor.row', array(
					'ROW_CLASS' => $row_class,
					'ID' => intval($r['id']),
					'TYP_ID' => OptiAdmin::view('int', $r['typ_id'], 'typ_id'),
					'BEST_YTA' => OptiAdmin::view('float', $r['best_yta'], 'best_yta'),
					'BEST_TJOCKLEK' => OptiAdmin::view('float', $r['best_tjocklek'], 'best_tjocklek'),
					'YTAN' => OptiAdmin::view('float', $r['ytan'], 'ytan'),
					'TJOCKLEK' => OptiAdmin::view('float', $r['tjocklek'], 'tjocklek'),
					'PRODUKT_NAMN' => OptiAdmin::view('text', $r['produkt_namn'], 'produkt_namn'),
					'SACKVIKT' => OptiAdmin::view('float', $r['sackvikt'], 'sackvikt'),
					'SATTNING' => OptiAdmin::view('float', $r['sattning'], 'sattning'),
					'MIN_DENSITET' => OptiAdmin::view('float', $r['min_densitet'], 'min_densitet'),
					'LINE_CATALOG_DESC' => OptiAdmin::view('text', $r['line_catalog_desc'], 'line_catalog_desc'),
					'LINE_VENDOR_NO' => OptiAdmin::view('text', $r['line_vendor_no'], 'line_vendor_no'),
					'LINE_AREA_AND_SIZE' => OptiAdmin::view('text', $r['line_area_and_size'], 'line_area_and_size'),
					'ANTAL_SACK_VERKLIG' => OptiAdmin::view('int', $r['antal_sack_verklig'], 'antal_sack_verklig'),
					'ANTAL_SACK_BERAKNAD' => OptiAdmin::view('int', $r['antal_sack_beraknad'], 'antal_sack_beraknad'),
					'LAMBDA' => OptiAdmin::view('float', $r['lambda'], 'lambda'),
					'ISPAROCPRODUKT' => OptiAdmin::view('bool', $r['isparocprodukt'], 'isparocprodukt'),
					'SACK_KUBIK' => OptiAdmin::view('float', $r['sack_kubik'], 'sack_kubik'),
					'ACTIVE' => OptiAdmin::view('bool', $r['active'], 'active'),
				));
			}
			unset($r);
		}
		else
		{
			echo '<p><em>'.$lang->no_result.'</em></p>';
		}
	}

	$tpl->pparse('ajax');
	die();
}



//------------------------------------------------------------------------------
// AJAX: Hub-Save (innan header)
//------------------------------------------------------------------------------
if ( $action == 'hub_save' )
{
	$hub = ( isset($_GET['hub']) ) ? $_GET['hub'] : NULL;
	$col_id = ( isset($_GET['col_id']) ) ? intval($_GET['col_id']) : NULL;

	//kör hub_list
	$action = 'hub_list';
}
//------------------------------------------------------------------------------
// AJAX: Hub-Delete AJAX (innan header)
//------------------------------------------------------------------------------
if ( $action == 'hub_delete' )
{
	$hub = ( isset($_GET['hub']) ) ? $_GET['hub'] : NULL;
	$hub_id = ( isset($_GET['hub_id']) ) ? intval($_GET['hub_id']) : NULL;

	//kör hub_list
	$action = 'hub_list';
}
//------------------------------------------------------------------------------
// AJAX: Hub-List (innan header)
//------------------------------------------------------------------------------
if ( $action == 'hub_list' )
{
	$tpl = new Template('templates_'.$language);
	$tpl->set_filenames(array('ajax' => $module.'_hub_list.tpl'));

	$hub = ( isset($_GET['hub']) ) ? $_GET['hub'] : NULL;

	$tpl->pparse('ajax');
	die();
}
//------------------------------------------------------------------------------
// AJAX: Hub-View (innan header)
//------------------------------------------------------------------------------
if ( $action == 'hub_view' )
{
	$tpl = new Template('templates_'.$language);
	$tpl->set_filenames(array('ajax' => $module.'_hub_view.tpl'));

	$hub = ( isset($_GET['hub']) ) ? $_GET['hub'] : NULL;

	$tpl->pparse('ajax');
	die();
}



//------------------------------------------------------------------------------
// AJAX: Add-User (innan header)
//------------------------------------------------------------------------------
if ( $module == 'index' && $action == 'add_user' )
{
	$username = ( isset($_POST['username']) ) ? clean($_POST['username']) : NULL;
	$password = ( isset($_POST['password']) ) ? trim($_POST['password']) : NULL;

	if ( $username && $password )
	{
		//skapar ny användare
		$user->add_user($username, $password);

		//vidarebefodra till Inställningar
		header('Location: '.$cfg->admin_base_filename.'?module=index&action=settings');
		die();
	}
	else
	{
		die('Saknar användarnamn eller lösenord');
	}
}
//------------------------------------------------------------------------------
// AJAX: Sparar ett värde i settings-tabellen (innan header)
//------------------------------------------------------------------------------
if ( $module == 'index' && $action == 'save_setting' )
{
	//hämta config_key och config_value från POST (OBS! config_value kan vara tomt!)
	$config_key = ( isset($_POST['config_key']) ) ? clean($_POST['config_key']) : NULL;
	$config_value = ( isset($_POST['config_value']) ) ? clean($_POST['config_value']) : NULL;

	if ( $config_key )
	{
		//sparar (skapar/uppdaterar) inställningen
		$cfg->save($config_key, $config_value);

		//skriv ut det nya värdet (hämtar det färskt från databasen)
		echo '<em>'.$cfg->get($config_key).'</em>';
		die();
	}
	else
	{
		die('Saknar config-nyckel');
	}
}
//------------------------------------------------------------------------------
// AJAX: Ta bort en rad från settings-tabellen (innan header)
//------------------------------------------------------------------------------
if ( $module == 'index' && $action == 'delete_setting' )
{
	//hämta config_id från GET
	$config_id = ( isset($_GET['config_id']) ) ? intval($_GET['config_id']) : NULL;

	if ( $config_id )
	{
		//tar bort inställningen
		$cfg->delete($config_id);

		//vidarebefodra till Inställningar
		header('Location: '.$cfg->admin_base_filename.'?module=index&action=settings');
		die();
	}
	else
	{
		die('Saknar config-id');
	}
}
//------------------------------------------------------------------------------
// AJAX: Sorterar en tabell (modul/multi/hub) (innan header)
//------------------------------------------------------------------------------
if ( $module == 'index' && $action == 'sort_table' )
{
	$table = ( isset($_POST['table']) ) ? $_POST['table'] : NULL;
	$primary_key = ( isset($_POST['primary_key']) ) ? $_POST['primary_key'] : NULL;
	$sortcol = ( isset($_POST['sortcol']) ) ? $_POST['sortcol'] : NULL;
	$order = ( isset($_POST['order']) ) ? $_POST['order'] : array();

	if ( $table && $primary_key && $sortcol && !empty($order) )
	{
		OptiAdmin::sort_table($table, $primary_key, $sortcol, $order);
		die('ok');
	}
	else
	{
		die('Saknar sorteringsdata');
	}
}



//------------------------------------------------------------------------------
// iFrame: Visar karta för geoposition (innan header)
//------------------------------------------------------------------------------
if ( $module == 'index' && $action == 'view_geoposition' )
{
	$tpl = new Template('templates_'.$language);
	$tpl->set_filenames(array('header' => 'header_iframe.tpl'));
	$tpl->assign_vars(array(
		'BASE_FILENAME' => $cfg->admin_base_filename,
	));
	$tpl->pparse('header');
	$tpl->set_filenames(array('iframe' => 'index_view_geoposition.tpl'));

	//hämta från GET
	$geopos = ( isset($_GET['geopos']) ) ? $_GET['geopos'] : NULL;

	//kolla geopositionen från GET
	$geopos = explode(',', $geopos);
	$lat = ( isset($geopos[0]) ) ? floatval($geopos[0]) : NULL;
	$lng = ( isset($geopos[1]) ) ? floatval($geopos[1]) : NULL;

	$tpl->assign_vars(array(
		'LAT' => $lat,
		'LNG' => $lng,
	));

	$tpl->pparse('iframe');
	include($root_path.'templates_'.$language.'/footer_iframe.tpl');
	die();
}
//------------------------------------------------------------------------------
// iFrame: Visar gränsnitt för redigering av geoposition (innan header)
//------------------------------------------------------------------------------
if ( $module == 'index' && $action == 'edit_geoposition' )
{
	$tpl = new Template('templates_'.$language);
	$tpl->set_filenames(array('header' => 'header_iframe.tpl'));
	$tpl->assign_vars(array(
		'BASE_FILENAME' => $cfg->admin_base_filename,
	));
	$tpl->pparse('header');
	$tpl->set_filenames(array('iframe' => 'index_edit_geoposition.tpl'));

	//hämta från GET
	$adress = ( isset($_GET['adress']) ) ? $_GET['adress'] : NULL;
	$geopos = ( isset($_GET['geopos']) ) ? $_GET['geopos'] : NULL;
	$input_name = ( isset($_GET['input_name']) ) ? $_GET['input_name'] : NULL;

	//kolla geopositionen från GET
	$geopos = explode(',', $geopos);
	$lat = ( isset($geopos[0]) ) ? floatval($geopos[0]) : NULL;
	$lng = ( isset($geopos[1]) ) ? floatval($geopos[1]) : NULL;

	//om vi har en geoposition från databasen
	if ( $lat && $lng )
	{
		$location_type = false;
		$zoom = '16';
	}
	else
	{
		//hämtar XML-data
		$google_adress = str_replace("\r\n", ', ', $adress);
		$google_adress = str_replace("\n", ', ', $google_adress);
		$request_url = 'http://maps.google.com/maps/api/geocode/xml?address='.urlencode($google_adress).'&sensor=false';
		$xml = simplexml_load_file($request_url) or die ('url not loading');
		$status = $xml->status;

		//om vi har fått en träff
		if ( $status == 'OK' )
		{
			$location_type = $xml->result->geometry->location_type;
			$lat = $xml->result->geometry->location->lat;
			$lng = $xml->result->geometry->location->lng;
			$zoom = '16';

			//färgkoda location_type
			$location_type = ( $location_type == 'ROOFTOP' ) ? '<span class="green">'.$location_type.'</span>' : '<span class="yellow">'.$location_type.'</span>' ;
		}
		else
		{
			//sätt lat och lng till mitt i Vättern
			$location_type = '<span class="red">INGEN TRÄFF</span>';
			$lat = '58.1909578';
			$lng = '14.4176998';
			$zoom = '3';
		}
	}

	$tpl->assign_vars(array(
		'INPUT_NAME' => $input_name,
		'TEXT_ADRESS' => str_replace(', ', "\n", $adress),
		'LAT' => $lat,
		'LNG' => $lng,
		'ZOOM' => $zoom,
	));

	//skapar block för träfftyp (om vi söker)
	if ( $location_type )
	{
		$tpl->assign_block_vars('trafftyp', array(
			'LOCATION_TYPE' => $location_type,
		));
	}

	$tpl->pparse('iframe');
	include($root_path.'templates_'.$language.'/footer_iframe.tpl');
	die();
}



//------------------------------------------------------------------------------
// Användare: Save (innan header)
//------------------------------------------------------------------------------
if ( $module == 'paroc_users' && $action == 'save' )
{
	//hämta ev. id (0 = nytt, 1+ = gammalt)
	$id = ( isset($_POST['id']) ) ? intval($_POST['id']) : 0;

	//hämta och rengör data från POST
	$namn = OptiAdmin::clean('text', 'namn');
	$kundnummer = OptiAdmin::clean('text', 'kundnummer');
	$leverantors_id = OptiAdmin::clean('text', 'leverantors_id');
	$telenummer = OptiAdmin::clean('text', 'telenummer');
	$adress = OptiAdmin::clean('text', 'adress');
	$postnummer = OptiAdmin::clean('text', 'postnummer');
	$ort = OptiAdmin::clean('text', 'ort');
	$user_typ = OptiAdmin::clean('select', 'user_typ');
	$password = OptiAdmin::clean('text', 'password');
	$template = OptiAdmin::clean('select', 'template');
	$sortorder = OptiAdmin::clean('sort', 'sortorder');
	$active = OptiAdmin::clean('bool', 'active');

	//förbered MySQL-queryn
	$sql_set = "namn = '$namn',
		kundnummer = '$kundnummer',
		leverantors_id = '$leverantors_id',
		telenummer = '$telenummer',
		adress = '$adress',
		postnummer = '$postnummer',
		ort = '$ort',
		user_typ = '$user_typ',
		password = '$password',
		template = '$template',
		sortorder = $sortorder,
		active = '$active'";

	//sparar (skapar/uppdaterar)
	$paroc_users = new Paroc_usersRow();
	$paroc_users->id = $id;
	$paroc_users->save($sql_set);

	//om vi ska redigera nästa id - redirecta till ?edit
	if ( isset($_POST['submit_save_next_id']) && intval($_POST['submit_save_next_id']) > 0 )
	{
		header('Location: '.$cfg->admin_base_filename.'?module=paroc_users&action=edit&id='.intval($_POST['submit_save_next_id']));
	}
	//om vi ska skapa ytterligare en ny - redirecta till ?add
	elseif ( isset($_POST['submit_add_new']) && intval($_POST['submit_add_new']) === 1 )
	{
		header('Location: '.$cfg->admin_base_filename.'?module=paroc_users&action=add');
	}
	//annars: visa aktuell id - redirecta till ?view
	else
	{
		header('Location: '.$cfg->admin_base_filename.'?module=paroc_users&action=view&id='.$paroc_users->id);
	}
	die();
}
//------------------------------------------------------------------------------
// Användare: Delete (innan header)
//------------------------------------------------------------------------------
if ( $module == 'paroc_users' && $action == 'delete' )
{
	//tar bort
	$paroc_users = new Paroc_usersRow();
	$paroc_users->id_from_get();
	$paroc_users->delete();

	//redirecta till ?list
	header('Location: '.$cfg->admin_base_filename.'?module=paroc_users&action=list');
	die();
}
//------------------------------------------------------------------------------
// Användare: Copy (innan header)
//------------------------------------------------------------------------------
if ( $module == 'paroc_users' && $action == 'copy' )
{
	//kopierar
	$paroc_users = new Paroc_usersRow();
	$paroc_users->id_from_get();
	$copy_id = $paroc_users->copy();

	//redirecta till ?view
	header('Location: '.$cfg->admin_base_filename.'?module=paroc_users&action=view&id='.$copy_id);
	die();
}



//------------------------------------------------------------------------------
// Produkter: Save (innan header)
//------------------------------------------------------------------------------
if ( $module == 'products' && $action == 'save' )
{
	//hämta ev. id (0 = nytt, 1+ = gammalt)
	$id = ( isset($_POST['id']) ) ? intval($_POST['id']) : 0;

	//hämta och rengör data från POST
	$name = OptiAdmin::clean('text', 'name');
	$typ = OptiAdmin::clean('select', 'typ');
	$vikt_sack = OptiAdmin::clean('float', 'vikt_sack');
	$sack_kubik = OptiAdmin::clean('float', 'sack_kubik');
	$sattning = OptiAdmin::clean('float', 'sattning');
	$min_densitet = OptiAdmin::clean('float', 'min_densitet');
	$lambavarde = OptiAdmin::clean('float', 'lambavarde');
	$sortorder = OptiAdmin::clean('sort', 'sortorder');
	$active = OptiAdmin::clean('bool', 'active');

	//förbered MySQL-queryn
	$sql_set = "name = '$name',
		typ = '$typ',
		vikt_sack = $vikt_sack,
		sack_kubik = $sack_kubik,
		sattning = $sattning,
		min_densitet = $min_densitet,
		lambavarde = $lambavarde,
		sortorder = $sortorder,
		active = '$active'";

	//sparar (skapar/uppdaterar)
	$products = new ProductsRow();
	$products->id = $id;
	$products->save($sql_set);

	//om vi ska redigera nästa id - redirecta till ?edit
	if ( isset($_POST['submit_save_next_id']) && intval($_POST['submit_save_next_id']) > 0 )
	{
		header('Location: '.$cfg->admin_base_filename.'?module=products&action=edit&id='.intval($_POST['submit_save_next_id']));
	}
	//om vi ska skapa ytterligare en ny - redirecta till ?add
	elseif ( isset($_POST['submit_add_new']) && intval($_POST['submit_add_new']) === 1 )
	{
		header('Location: '.$cfg->admin_base_filename.'?module=products&action=add');
	}
	//annars: visa aktuell id - redirecta till ?view
	else
	{
		header('Location: '.$cfg->admin_base_filename.'?module=products&action=view&id='.$products->id);
	}
	die();
}
//------------------------------------------------------------------------------
// Produkter: Delete (innan header)
//------------------------------------------------------------------------------
if ( $module == 'products' && $action == 'delete' )
{
	//tar bort
	$products = new ProductsRow();
	$products->id_from_get();
	$products->delete();

	//redirecta till ?list
	header('Location: '.$cfg->admin_base_filename.'?module=products&action=list');
	die();
}
//------------------------------------------------------------------------------
// Produkter: Copy (innan header)
//------------------------------------------------------------------------------
if ( $module == 'products' && $action == 'copy' )
{
	//kopierar
	$products = new ProductsRow();
	$products->id_from_get();
	$copy_id = $products->copy();

	//redirecta till ?view
	header('Location: '.$cfg->admin_base_filename.'?module=products&action=view&id='.$copy_id);
	die();
}



//------------------------------------------------------------------------------
// Protokoll: Save (innan header)
//------------------------------------------------------------------------------
if ( $module == 'protocol' && $action == 'save' )
{
	//hämta ev. id (0 = nytt, 1+ = gammalt)
	$id = ( isset($_POST['id']) ) ? intval($_POST['id']) : 0;

	//hämta och rengör data från POST
	$selection_date = OptiAdmin::clean('date', 'selection_date');
	$order_no = OptiAdmin::clean('text', 'order_no');
	$installators_orderid = OptiAdmin::clean('text', 'installators_orderid');
	$customer_no = OptiAdmin::clean('text', 'customer_no');
	$line_vendor_no = OptiAdmin::clean('text', 'line_vendor_no');
	$customer_name = OptiAdmin::clean('text', 'customer_name');
	$wanted_delivery_date = OptiAdmin::clean('date', 'wanted_delivery_date');
	$reference = OptiAdmin::clean('text', 'reference');
	$customer_po_no = OptiAdmin::clean('text', 'customer_po_no');
	$date_entered = OptiAdmin::clean('datetime', 'date_entered');
	$company_name2 = OptiAdmin::clean('text', 'company_name2');
	$address1 = OptiAdmin::clean('text', 'address1');
	$address2 = OptiAdmin::clean('text', 'address2');
	$county = OptiAdmin::clean('text', 'county');
	$state = OptiAdmin::clean('text', 'state');
	$country_code = OptiAdmin::clean('text', 'country_code');
	$country = OptiAdmin::clean('text', 'country');
	$installations_datum = OptiAdmin::clean('date', 'installations_datum');
	$arbetsnummer = OptiAdmin::clean('text', 'arbetsnummer');
	$etapp = OptiAdmin::clean('text', 'etapp');
	$sing_installator = OptiAdmin::clean('text', 'sing_installator');
	$sing_arbetsledare = OptiAdmin::clean('text', 'sing_arbetsledare');
	$kontroll_checklista = OptiAdmin::clean('bool', 'kontroll_checklista');
	$kommentar = OptiAdmin::clean('textarea', 'kommentar');
	$kontakt_person = OptiAdmin::clean('text', 'kontakt_person');
	$produkt_tg_ce_nummer = OptiAdmin::clean('text', 'produkt_tg_ce_nummer');
	$publicerat = OptiAdmin::clean('bool', 'publicerat');
	$sortorder = OptiAdmin::clean('sort', 'sortorder');
	$active = OptiAdmin::clean('bool', 'active');

	//förbered MySQL-queryn
	$sql_set = "selection_date = '$selection_date',
		order_no = '$order_no',
		installators_orderid = '$installators_orderid',
		customer_no = '$customer_no',
		line_vendor_no = '$line_vendor_no',
		customer_name = '$customer_name',
		wanted_delivery_date = '$wanted_delivery_date',
		reference = '$reference',
		customer_po_no = '$customer_po_no',
		date_entered = '$date_entered',
		company_name2 = '$company_name2',
		address1 = '$address1',
		address2 = '$address2',
		county = '$county',
		state = '$state',
		country_code = '$country_code',
		country = '$country',
		installations_datum = '$installations_datum',
		arbetsnummer = '$arbetsnummer',
		etapp = '$etapp',
		sing_installator = '$sing_installator',
		sing_arbetsledare = '$sing_arbetsledare',
		kontroll_checklista = '$kontroll_checklista',
		kommentar = '$kommentar',
		kontakt_person = '$kontakt_person',
		produkt_tg_ce_nummer = '$produkt_tg_ce_nummer',
		publicerat = '$publicerat',
		sortorder = $sortorder,
		active = '$active'";

	//sparar (skapar/uppdaterar)
	$protocol = new ProtocolRow();
	$protocol->id = $id;
	$protocol->save($sql_set);

	//om vi ska redigera nästa id - redirecta till ?edit
	if ( isset($_POST['submit_save_next_id']) && intval($_POST['submit_save_next_id']) > 0 )
	{
		header('Location: '.$cfg->admin_base_filename.'?module=protocol&action=edit&id='.intval($_POST['submit_save_next_id']));
	}
	//om vi ska skapa ytterligare en ny - redirecta till ?add
	elseif ( isset($_POST['submit_add_new']) && intval($_POST['submit_add_new']) === 1 )
	{
		header('Location: '.$cfg->admin_base_filename.'?module=protocol&action=add');
	}
	//annars: visa aktuell id - redirecta till ?view
	else
	{
		header('Location: '.$cfg->admin_base_filename.'?module=protocol&action=view&id='.$protocol->id);
	}
	die();
}
//------------------------------------------------------------------------------
// Protokoll: Delete (innan header)
//------------------------------------------------------------------------------
if ( $module == 'protocol' && $action == 'delete' )
{
	//tar bort
	$protocol = new ProtocolRow();
	$protocol->id_from_get();
	$protocol->delete();

	//redirecta till ?list
	header('Location: '.$cfg->admin_base_filename.'?module=protocol&action=list');
	die();
}
//------------------------------------------------------------------------------
// Protokoll: Copy (innan header)
//------------------------------------------------------------------------------
if ( $module == 'protocol' && $action == 'copy' )
{
	//kopierar
	$protocol = new ProtocolRow();
	$protocol->id_from_get();
	$copy_id = $protocol->copy();

	//redirecta till ?view
	header('Location: '.$cfg->admin_base_filename.'?module=protocol&action=view&id='.$copy_id);
	die();
}



//------------------------------------------------------------------------------
// Ytor: Save (innan header)
//------------------------------------------------------------------------------
if ( $module == 'surfaces' && $action == 'save' )
{
	//hämta ev. id (0 = nytt, 1+ = gammalt)
	$id = ( isset($_POST['id']) ) ? intval($_POST['id']) : 0;

	//hämta och rengör data från POST
	$prokoll_id = OptiAdmin::clean('foreign', 'prokoll_id');
	$typ_id = OptiAdmin::clean('int', 'typ_id');
	$best_yta = OptiAdmin::clean('float', 'best_yta');
	$best_tjocklek = OptiAdmin::clean('float', 'best_tjocklek');
	$ytan = OptiAdmin::clean('float', 'ytan');
	$tjocklek = OptiAdmin::clean('float', 'tjocklek');
	$produkt_namn = OptiAdmin::clean('text', 'produkt_namn');
	$sackvikt = OptiAdmin::clean('float', 'sackvikt');
	$sattning = OptiAdmin::clean('float', 'sattning');
	$min_densitet = OptiAdmin::clean('float', 'min_densitet');
	$line_catalog_desc = OptiAdmin::clean('text', 'line_catalog_desc');
	$line_vendor_no = OptiAdmin::clean('text', 'line_vendor_no');
	$line_area_and_size = OptiAdmin::clean('text', 'line_area_and_size');
	$antal_sack_verklig = OptiAdmin::clean('int', 'antal_sack_verklig');
	$antal_sack_beraknad = OptiAdmin::clean('int', 'antal_sack_beraknad');
	$lambda = OptiAdmin::clean('float', 'lambda');
	$isparocprodukt = OptiAdmin::clean('bool', 'isparocprodukt');
	$sack_kubik = OptiAdmin::clean('float', 'sack_kubik');
	$sortorder = OptiAdmin::clean('sort', 'sortorder');
	$active = OptiAdmin::clean('bool', 'active');

	//förbered MySQL-queryn
	$sql_set = "prokoll_id = '$prokoll_id',
		typ_id = $typ_id,
		best_yta = $best_yta,
		best_tjocklek = $best_tjocklek,
		ytan = $ytan,
		tjocklek = $tjocklek,
		produkt_namn = '$produkt_namn',
		sackvikt = $sackvikt,
		sattning = $sattning,
		min_densitet = $min_densitet,
		line_catalog_desc = '$line_catalog_desc',
		line_vendor_no = '$line_vendor_no',
		line_area_and_size = '$line_area_and_size',
		antal_sack_verklig = $antal_sack_verklig,
		antal_sack_beraknad = $antal_sack_beraknad,
		lambda = $lambda,
		isparocprodukt = '$isparocprodukt',
		sack_kubik = $sack_kubik,
		sortorder = $sortorder,
		active = '$active'";

	//sparar (skapar/uppdaterar)
	$surfaces = new SurfacesRow();
	$surfaces->id = $id;
	$surfaces->save($sql_set);

	//om vi ska redigera nästa id - redirecta till ?edit
	if ( isset($_POST['submit_save_next_id']) && intval($_POST['submit_save_next_id']) > 0 )
	{
		header('Location: '.$cfg->admin_base_filename.'?module=surfaces&action=edit&id='.intval($_POST['submit_save_next_id']));
	}
	//om vi ska skapa ytterligare en ny - redirecta till ?add
	elseif ( isset($_POST['submit_add_new']) && intval($_POST['submit_add_new']) === 1 )
	{
		header('Location: '.$cfg->admin_base_filename.'?module=surfaces&action=add');
	}
	//annars: visa aktuell id - redirecta till ?view
	else
	{
		header('Location: '.$cfg->admin_base_filename.'?module=surfaces&action=view&id='.$surfaces->id);
	}
	die();
}
//------------------------------------------------------------------------------
// Ytor: Delete (innan header)
//------------------------------------------------------------------------------
if ( $module == 'surfaces' && $action == 'delete' )
{
	//tar bort
	$surfaces = new SurfacesRow();
	$surfaces->id_from_get();
	$surfaces->delete();

	//redirecta till ?list
	header('Location: '.$cfg->admin_base_filename.'?module=surfaces&action=list');
	die();
}
//------------------------------------------------------------------------------
// Ytor: Copy (innan header)
//------------------------------------------------------------------------------
if ( $module == 'surfaces' && $action == 'copy' )
{
	//kopierar
	$surfaces = new SurfacesRow();
	$surfaces->id_from_get();
	$copy_id = $surfaces->copy();

	//redirecta till ?view
	header('Location: '.$cfg->admin_base_filename.'?module=surfaces&action=view&id='.$copy_id);
	die();
}



//------------------------------------------------------------------------------
// Generera HEADER
//------------------------------------------------------------------------------
//ob_start('ob_gzhandler');
$tpl = new Template('templates_'.$language);
$tpl->set_filenames(array('header' => 'header.tpl'));
//ladda TinyMCE
if ( $action == 'add' || $action == 'edit' )
{
	$tpl->assign_block_vars('tinymce', array());
}
$tpl->assign_vars(array(
	'BASE_FILENAME' => $cfg->admin_base_filename,
	'PAGE_TITLE' => $cfg->admin_page_title,
	'MODULE_ACTION' => $module.'_'.$action,
));
$tpl->pparse('header');



//------------------------------------------------------------------------------
// Index :: Index
//------------------------------------------------------------------------------
if ( $module == 'index' && $action == 'index' )
{
	$tpl->set_filenames(array('body' => 'index.tpl'));

	//...

	$tpl->pparse('body');
}
//------------------------------------------------------------------------------
// Index :: Settings
//------------------------------------------------------------------------------
if ( $module == 'index' && $action == 'settings' )
{
	$tpl->set_filenames(array('body' => 'index_settings.tpl'));

	//enstaka inställningar
	$tpl->assign_vars(array(
		'MYSQL_LIMIT' => $cfg->get('mysql_limit'),
	));

	//gå igenom alla inställningar
	foreach ($cfg->data as $d)
	{
		//skriv ut användare
		if ( $d['config_key'] == 'user' )
		{
			$value = explode('|', $d['config_value']);
			$tpl->assign_block_vars('user', array(
				'ID' => $d['id'],
				'USERNAME' => $value[0],
			));
		}
	}

	$tpl->pparse('body');
}



//------------------------------------------------------------------------------
// Användare: List
//------------------------------------------------------------------------------
if ( $module == 'paroc_users' && $action == 'list' )
{
	$tpl->set_filenames(array('body' => 'paroc_users_list.tpl'));

	$paroc_users = new Paroc_usersTable();
	$paroc_users->url = $cfg->admin_base_filename.'?module=paroc_users&action=list';
	$paroc_users->load_params('params_paroc_users_list');
	$paroc_users->load_sql();

	foreach ($paroc_users->rows as $r)
	{
		$row_class = ( isset($row_class) && $row_class == 'row1' ) ? 'row2' : 'row1';
		$tpl->assign_block_vars('paroc_users', array(
			'ROW_CLASS' => $row_class,
			'ID' => OptiAdmin::view('int', $r['id'], 'id'),
			'NAMN' => OptiAdmin::view('text', $r['namn'], 'namn'),
			'KUNDNUMMER' => OptiAdmin::view('text', $r['kundnummer'], 'kundnummer'),
			'LEVERANTORS_ID' => OptiAdmin::view('text', $r['leverantors_id'], 'leverantors_id'),
			'TELENUMMER' => OptiAdmin::view('text', $r['telenummer'], 'telenummer'),
			'ADRESS' => OptiAdmin::view('text', $r['adress'], 'adress'),
			'POSTNUMMER' => OptiAdmin::view('text', $r['postnummer'], 'postnummer'),
			'ORT' => OptiAdmin::view('text', $r['ort'], 'ort'),
			'USER_TYP' => OptiAdmin::view('select', $r['user_typ'], 'user_typ'),
			'PASSWORD' => OptiAdmin::view('text', $r['password'], 'password'),
			'TEMPLATE' => OptiAdmin::view('select', $r['template'], 'template'),
			'SORTORDER' => OptiAdmin::view('sort', $r['sortorder'], 'sortorder'),
			'ACTIVE' => OptiAdmin::view('bool', $r['active'], 'active'),
		));
	}
	unset($r);

	$tpl->assign_vars(array(
		'FILTER_USER_TYP' => ( isset($paroc_users->filter['user_typ']) ) ? OptiAdmin::edit('select', $paroc_users->filter['user_typ'], 'user_typ', true) : OptiAdmin::edit('select', '', 'user_typ', true),
		'FILTER_TEMPLATE' => ( isset($paroc_users->filter['template']) ) ? OptiAdmin::edit('select', $paroc_users->filter['template'], 'template', true) : OptiAdmin::edit('select', '', 'template', true),
		'FILTER_ACTIVE' => ( isset($paroc_users->filter['active']) ) ? OptiAdmin::edit('bool', $paroc_users->filter['active'], 'active', true) : OptiAdmin::edit('bool', '', 'active', true),
		'SEARCH_STRING' => $paroc_users->search,
		'SORT_ID' => $paroc_users->create_sortable('id', 'Id'),
		'SORT_NAMN' => $paroc_users->create_sortable('namn', 'Namn'),
		'SORT_KUNDNUMMER' => $paroc_users->create_sortable('kundnummer', 'Kundnummer'),
		'SORT_LEVERANTORS_ID' => $paroc_users->create_sortable('leverantors_id', 'Leverantörs id'),
		'SORT_TELENUMMER' => $paroc_users->create_sortable('telenummer', 'Telenummer'),
		'SORT_ADRESS' => $paroc_users->create_sortable('adress', 'Adress'),
		'SORT_POSTNUMMER' => $paroc_users->create_sortable('postnummer', 'Postnummer'),
		'SORT_ORT' => $paroc_users->create_sortable('ort', 'Ort'),
		'SORT_USER_TYP' => $paroc_users->create_sortable('user_typ', 'Användar typ'),
		'SORT_PASSWORD' => $paroc_users->create_sortable('password', 'Lösenord'),
		'SORT_TEMPLATE' => $paroc_users->create_sortable('template', 'Template'),
		'SORT_SORTORDER' => $paroc_users->create_sortable('sortorder', 'Sortorder'),
		'SORT_ACTIVE' => $paroc_users->create_sortable('active', 'Active'),
		'FILTER_SEARCH_MESSAGE' => ( $paroc_users->filter_search_message ) ? '<div class="notice_box">'.$paroc_users->filter_search_message.'</div>' : '',
		'NUMROWS' => ( $paroc_users->antal < $paroc_users->found_rows ) ? '<div class="numrows">Visar '.$paroc_users->antal.' (av '.$paroc_users->found_rows.' st. totalt)</div>' : '<div class="numrows">'.$paroc_users->antal.' st. totalt</div>',
		'PAGENAV' => $paroc_users->create_pagenav(),
		'SORTERA' => ( $paroc_users->antal < $paroc_users->found_rows || $paroc_users->filter_search_message ) ? '<span class="icon_disabled_sort" title="Sortering enbart möjlig när alla rader visas">Sortera</span>' : '<span class="link icon_sort">Sortera</span>',
	));

	//om vi visar alla rader samtidigt (och ingen filtrering/sök): möjliggör sortering
	if ( $paroc_users->antal == $paroc_users->found_rows && !$paroc_users->filter_search_message )
	{
		$tpl->assign_block_vars('js_sortcol', array());
	}

	//sparar userdata (parametrar & id:s) i SESSION
	$user->data['id_list_paroc_users_list'] = $paroc_users->id_list;
	$user->save_data();

	$tpl->pparse('body');
}
//------------------------------------------------------------------------------
// Användare: View
//------------------------------------------------------------------------------
if ( $module == 'paroc_users' && $action == 'view' )
{
	$tpl->set_filenames(array('body' => 'paroc_users_view.tpl'));

	$paroc_users = new Paroc_usersRow();
	$paroc_users->url = $cfg->admin_base_filename.'?module=paroc_users&action=view';
	$paroc_users->url_up = $cfg->admin_base_filename.'?module=paroc_users&action=list';
	$paroc_users->id_from_get();
	$paroc_users->load_data();

	$tpl->assign_vars(array(
		'ID' => OptiAdmin::view('int', $paroc_users->data['id'], 'id'),
		'NAMN' => OptiAdmin::view('text', $paroc_users->data['namn'], 'namn'),
		'KUNDNUMMER' => OptiAdmin::view('text', $paroc_users->data['kundnummer'], 'kundnummer'),
		'LEVERANTORS_ID' => OptiAdmin::view('text', $paroc_users->data['leverantors_id'], 'leverantors_id'),
		'TELENUMMER' => OptiAdmin::view('text', $paroc_users->data['telenummer'], 'telenummer'),
		'ADRESS' => OptiAdmin::view('text', $paroc_users->data['adress'], 'adress'),
		'POSTNUMMER' => OptiAdmin::view('text', $paroc_users->data['postnummer'], 'postnummer'),
		'ORT' => OptiAdmin::view('text', $paroc_users->data['ort'], 'ort'),
		'USER_TYP' => OptiAdmin::view('select', $paroc_users->data['user_typ'], 'user_typ'),
		'PASSWORD' => OptiAdmin::view('text', $paroc_users->data['password'], 'password'),
		'TEMPLATE' => OptiAdmin::view('select', $paroc_users->data['template'], 'template'),
		'SORTORDER' => OptiAdmin::view('sort', $paroc_users->data['sortorder'], 'sortorder'),
		'ACTIVE' => OptiAdmin::view('bool', $paroc_users->data['active'], 'active'),
		'NAVBAR' => $paroc_users->create_navbar('id_list_paroc_users_list'),
	));

	$tpl->pparse('body');
}
//------------------------------------------------------------------------------
// Användare: Add
//------------------------------------------------------------------------------
if ( $module == 'paroc_users' && $action == 'add' )
{
	$tpl->set_filenames(array('body' => 'paroc_users_add.tpl'));

	$paroc_users = new Paroc_usersRow();

	$tpl->assign_vars(array(
		'INPUT_NAMN' => OptiAdmin::edit('text', NULL, 'namn'),
		'INPUT_KUNDNUMMER' => OptiAdmin::edit('text', NULL, 'kundnummer'),
		'INPUT_LEVERANTORS_ID' => OptiAdmin::edit('text', NULL, 'leverantors_id'),
		'INPUT_TELENUMMER' => OptiAdmin::edit('text', NULL, 'telenummer'),
		'INPUT_ADRESS' => OptiAdmin::edit('text', NULL, 'adress'),
		'INPUT_POSTNUMMER' => OptiAdmin::edit('text', NULL, 'postnummer'),
		'INPUT_ORT' => OptiAdmin::edit('text', NULL, 'ort'),
		'INPUT_USER_TYP' => OptiAdmin::edit('select', NULL, 'user_typ'),
		'INPUT_PASSWORD' => OptiAdmin::edit('text', NULL, 'password'),
		'INPUT_TEMPLATE' => OptiAdmin::edit('select', NULL, 'template'),
		'INPUT_SORTORDER' => OptiAdmin::edit('sort', NULL, 'sortorder'),
		'INPUT_ACTIVE' => OptiAdmin::edit('bool', NULL, 'active'),
	));

	$tpl->pparse('body');
}
//------------------------------------------------------------------------------
// Användare: Edit
//------------------------------------------------------------------------------
if ( $module == 'paroc_users' && $action == 'edit' )
{
	$tpl->set_filenames(array('body' => 'paroc_users_edit.tpl'));

	$paroc_users = new Paroc_usersRow();
	$paroc_users->url = $cfg->admin_base_filename.'?module=paroc_users&action=edit';
	$paroc_users->url_up = $cfg->admin_base_filename.'?module=paroc_users&action=list';
	$paroc_users->id_from_get();
	$paroc_users->load_data();

	$tpl->assign_vars(array(
		'ID' => $paroc_users->id,
		'INPUT_NAMN' => OptiAdmin::edit('text', $paroc_users->data['namn'], 'namn'),
		'INPUT_KUNDNUMMER' => OptiAdmin::edit('text', $paroc_users->data['kundnummer'], 'kundnummer'),
		'INPUT_LEVERANTORS_ID' => OptiAdmin::edit('text', $paroc_users->data['leverantors_id'], 'leverantors_id'),
		'INPUT_TELENUMMER' => OptiAdmin::edit('text', $paroc_users->data['telenummer'], 'telenummer'),
		'INPUT_ADRESS' => OptiAdmin::edit('text', $paroc_users->data['adress'], 'adress'),
		'INPUT_POSTNUMMER' => OptiAdmin::edit('text', $paroc_users->data['postnummer'], 'postnummer'),
		'INPUT_ORT' => OptiAdmin::edit('text', $paroc_users->data['ort'], 'ort'),
		'INPUT_USER_TYP' => OptiAdmin::edit('select', $paroc_users->data['user_typ'], 'user_typ'),
		'INPUT_PASSWORD' => OptiAdmin::edit('text', $paroc_users->data['password'], 'password'),
		'INPUT_TEMPLATE' => OptiAdmin::edit('select', $paroc_users->data['template'], 'template'),
		'INPUT_SORTORDER' => OptiAdmin::edit('sort', $paroc_users->data['sortorder'], 'sortorder'),
		'INPUT_ACTIVE' => OptiAdmin::edit('bool', $paroc_users->data['active'], 'active'),
		'NAVBAR' => $paroc_users->create_navbar('id_list_paroc_users_list'),
		'SUBMIT_SAVE_NEXT_ID' => ( $paroc_users->next_id ) ? '<button type="submit" name="submit_save_next_id" value="'.$paroc_users->next_id.'"><img src="images/icon_save_next.png" /> Spara/nästa</button>&nbsp;&nbsp;' : '',
	));

	$tpl->pparse('body');
}
//------------------------------------------------------------------------------
// Användare: Export
//------------------------------------------------------------------------------
if ( $module == 'paroc_users' && $action == 'export' )
{
	$tpl->set_filenames(array('body' => 'paroc_users_export.tpl'));

	//step2
	if ( isset($_POST['format']) && in_array($_POST['format'], array('excel', 'csv', 'text')) && isset($_POST['columns']) && count($_POST['columns']) > 0 )
	{
		$format = $_POST['format'];

		//hämtar data
		$paroc_users = new Paroc_usersTable();
		$paroc_users->url = $cfg->admin_base_filename.'?module=paroc_users&action=export';
		$paroc_users->load_params('params_paroc_users_list');
		$paroc_users->limit = 0; //sätter LIMIT = 0 så vi får med alla rows
		$paroc_users->load_sql();

		//inkluderar class-filen för exportering
		require($root_path.'includes/class_export.php');

		if ( $format == 'excel' )
		{
			$export = new ExcelExport();
		}
		elseif ( $format == 'csv' )
		{
			$export = new CSVExport();
		}
		elseif ( $format == 'text' )
		{
			$export = new OptiExport();
		}

		//hämtar kolumner från POST (enbart markerade kommer exporteras)
		$columns = array();
		$captions = array();
		foreach ($_POST['columns'] as $col)
		{
			$col = explode('|', $col);
			$columns[] = $col[0];
			$captions[] = $col[1];
		}
		unset($col);

		//skriver ut kolumnrubriker
		$export->addHeader($captions);

		//går igenom och skriver ut alla rader
		foreach ($paroc_users->rows as $r)
		{
			$data = array();
			foreach ($columns as $colname)
			{
				$data[] = $r[$colname];
			}
			unset($colname);

			$export->addRow($data);
		}
		unset($r);

		//sparar filen
		if ( $export->createFile($cfg->export_path) )
		{
			$tpl->assign_block_vars('step2', array(
				'ROW_COUNTER' => $export->row_counter,
				'EXPORT_PATH' => $cfg->export_path,
				'FILENAME' => $export->filename,
			));
		}
		else
		{
			die($export->error);
		}
	}
	//step1
	else
	{
		$tpl->assign_block_vars('step1', array());
	}

	$tpl->pparse('body');
}



//------------------------------------------------------------------------------
// Produkter: List
//------------------------------------------------------------------------------
if ( $module == 'products' && $action == 'list' )
{
	$tpl->set_filenames(array('body' => 'products_list.tpl'));

	$products = new ProductsTable();
	$products->url = $cfg->admin_base_filename.'?module=products&action=list';
	$products->load_params('params_products_list');
	$products->load_sql();

	foreach ($products->rows as $r)
	{
		$row_class = ( isset($row_class) && $row_class == 'row1' ) ? 'row2' : 'row1';
		$tpl->assign_block_vars('products', array(
			'ROW_CLASS' => $row_class,
			'ID' => OptiAdmin::view('int', $r['id'], 'id'),
			'NAME' => OptiAdmin::view('text', $r['name'], 'name'),
			'TYP' => OptiAdmin::view('select', $r['typ'], 'typ'),
			'VIKT_SACK' => OptiAdmin::view('float', $r['vikt_sack'], 'vikt_sack'),
			'SACK_KUBIK' => OptiAdmin::view('float', $r['sack_kubik'], 'sack_kubik'),
			'SATTNING' => OptiAdmin::view('float', $r['sattning'], 'sattning'),
			'MIN_DENSITET' => OptiAdmin::view('float', $r['min_densitet'], 'min_densitet'),
			'LAMBAVARDE' => OptiAdmin::view('float', $r['lambavarde'], 'lambavarde'),
			'SORTORDER' => OptiAdmin::view('sort', $r['sortorder'], 'sortorder'),
			'ACTIVE' => OptiAdmin::view('bool', $r['active'], 'active'),
		));
	}
	unset($r);

	$tpl->assign_vars(array(
		'FILTER_TYP' => ( isset($products->filter['typ']) ) ? OptiAdmin::edit('select', $products->filter['typ'], 'typ', true) : OptiAdmin::edit('select', '', 'typ', true),
		'FILTER_ACTIVE' => ( isset($products->filter['active']) ) ? OptiAdmin::edit('bool', $products->filter['active'], 'active', true) : OptiAdmin::edit('bool', '', 'active', true),
		'SEARCH_STRING' => $products->search,
		'SORT_ID' => $products->create_sortable('id', 'Id'),
		'SORT_NAME' => $products->create_sortable('name', 'Namn'),
		'SORT_TYP' => $products->create_sortable('typ', 'Typ'),
		'SORT_VIKT_SACK' => $products->create_sortable('vikt_sack', 'Vikt säck'),
		'SORT_SACK_KUBIK' => $products->create_sortable('sack_kubik', 'Säck kubik'),
		'SORT_SATTNING' => $products->create_sortable('sattning', 'Sättning'),
		'SORT_MIN_DENSITET' => $products->create_sortable('min_densitet', 'Min-densitet'),
		'SORT_LAMBAVARDE' => $products->create_sortable('lambavarde', 'Lambavärde'),
		'SORT_SORTORDER' => $products->create_sortable('sortorder', 'Sortorder'),
		'SORT_ACTIVE' => $products->create_sortable('active', 'Active'),
		'FILTER_SEARCH_MESSAGE' => ( $products->filter_search_message ) ? '<div class="notice_box">'.$products->filter_search_message.'</div>' : '',
		'NUMROWS' => ( $products->antal < $products->found_rows ) ? '<div class="numrows">Visar '.$products->antal.' (av '.$products->found_rows.' st. totalt)</div>' : '<div class="numrows">'.$products->antal.' st. totalt</div>',
		'PAGENAV' => $products->create_pagenav(),
		'SORTERA' => ( $products->antal < $products->found_rows || $products->filter_search_message ) ? '<span class="icon_disabled_sort" title="Sortering enbart möjlig när alla rader visas">Sortera</span>' : '<span class="link icon_sort">Sortera</span>',
	));

	//om vi visar alla rader samtidigt (och ingen filtrering/sök): möjliggör sortering
	if ( $products->antal == $products->found_rows && !$products->filter_search_message )
	{
		$tpl->assign_block_vars('js_sortcol', array());
	}

	//sparar userdata (parametrar & id:s) i SESSION
	$user->data['id_list_products_list'] = $products->id_list;
	$user->save_data();

	$tpl->pparse('body');
}
//------------------------------------------------------------------------------
// Produkter: View
//------------------------------------------------------------------------------
if ( $module == 'products' && $action == 'view' )
{
	$tpl->set_filenames(array('body' => 'products_view.tpl'));

	$products = new ProductsRow();
	$products->url = $cfg->admin_base_filename.'?module=products&action=view';
	$products->url_up = $cfg->admin_base_filename.'?module=products&action=list';
	$products->id_from_get();
	$products->load_data();

	$tpl->assign_vars(array(
		'ID' => OptiAdmin::view('int', $products->data['id'], 'id'),
		'NAME' => OptiAdmin::view('text', $products->data['name'], 'name'),
		'TYP' => OptiAdmin::view('select', $products->data['typ'], 'typ'),
		'VIKT_SACK' => OptiAdmin::view('float', $products->data['vikt_sack'], 'vikt_sack'),
		'SACK_KUBIK' => OptiAdmin::view('float', $products->data['sack_kubik'], 'sack_kubik'),
		'SATTNING' => OptiAdmin::view('float', $products->data['sattning'], 'sattning'),
		'MIN_DENSITET' => OptiAdmin::view('float', $products->data['min_densitet'], 'min_densitet'),
		'LAMBAVARDE' => OptiAdmin::view('float', $products->data['lambavarde'], 'lambavarde'),
		'SORTORDER' => OptiAdmin::view('sort', $products->data['sortorder'], 'sortorder'),
		'ACTIVE' => OptiAdmin::view('bool', $products->data['active'], 'active'),
		'NAVBAR' => $products->create_navbar('id_list_products_list'),
	));

	$tpl->pparse('body');
}
//------------------------------------------------------------------------------
// Produkter: Add
//------------------------------------------------------------------------------
if ( $module == 'products' && $action == 'add' )
{
	$tpl->set_filenames(array('body' => 'products_add.tpl'));

	$products = new ProductsRow();

	$tpl->assign_vars(array(
		'INPUT_NAME' => OptiAdmin::edit('text', NULL, 'name'),
		'INPUT_TYP' => OptiAdmin::edit('select', NULL, 'typ'),
		'INPUT_VIKT_SACK' => OptiAdmin::edit('float', NULL, 'vikt_sack'),
		'INPUT_SACK_KUBIK' => OptiAdmin::edit('float', NULL, 'sack_kubik'),
		'INPUT_SATTNING' => OptiAdmin::edit('float', NULL, 'sattning'),
		'INPUT_MIN_DENSITET' => OptiAdmin::edit('float', NULL, 'min_densitet'),
		'INPUT_LAMBAVARDE' => OptiAdmin::edit('float', NULL, 'lambavarde'),
		'INPUT_SORTORDER' => OptiAdmin::edit('sort', NULL, 'sortorder'),
		'INPUT_ACTIVE' => OptiAdmin::edit('bool', NULL, 'active'),
	));

	$tpl->pparse('body');
}
//------------------------------------------------------------------------------
// Produkter: Edit
//------------------------------------------------------------------------------
if ( $module == 'products' && $action == 'edit' )
{
	$tpl->set_filenames(array('body' => 'products_edit.tpl'));

	$products = new ProductsRow();
	$products->url = $cfg->admin_base_filename.'?module=products&action=edit';
	$products->url_up = $cfg->admin_base_filename.'?module=products&action=list';
	$products->id_from_get();
	$products->load_data();

	$tpl->assign_vars(array(
		'ID' => $products->id,
		'INPUT_NAME' => OptiAdmin::edit('text', $products->data['name'], 'name'),
		'INPUT_TYP' => OptiAdmin::edit('select', $products->data['typ'], 'typ'),
		'INPUT_VIKT_SACK' => OptiAdmin::edit('float', $products->data['vikt_sack'], 'vikt_sack'),
		'INPUT_SACK_KUBIK' => OptiAdmin::edit('float', $products->data['sack_kubik'], 'sack_kubik'),
		'INPUT_SATTNING' => OptiAdmin::edit('float', $products->data['sattning'], 'sattning'),
		'INPUT_MIN_DENSITET' => OptiAdmin::edit('float', $products->data['min_densitet'], 'min_densitet'),
		'INPUT_LAMBAVARDE' => OptiAdmin::edit('float', $products->data['lambavarde'], 'lambavarde'),
		'INPUT_SORTORDER' => OptiAdmin::edit('sort', $products->data['sortorder'], 'sortorder'),
		'INPUT_ACTIVE' => OptiAdmin::edit('bool', $products->data['active'], 'active'),
		'NAVBAR' => $products->create_navbar('id_list_products_list'),
		'SUBMIT_SAVE_NEXT_ID' => ( $products->next_id ) ? '<button type="submit" name="submit_save_next_id" value="'.$products->next_id.'"><img src="images/icon_save_next.png" /> Spara/nästa</button>&nbsp;&nbsp;' : '',
	));

	$tpl->pparse('body');
}
//------------------------------------------------------------------------------
// Produkter: Export
//------------------------------------------------------------------------------
if ( $module == 'products' && $action == 'export' )
{
	$tpl->set_filenames(array('body' => 'products_export.tpl'));

	//step2
	if ( isset($_POST['format']) && in_array($_POST['format'], array('excel', 'csv', 'text')) && isset($_POST['columns']) && count($_POST['columns']) > 0 )
	{
		$format = $_POST['format'];

		//hämtar data
		$products = new ProductsTable();
		$products->url = $cfg->admin_base_filename.'?module=products&action=export';
		$products->load_params('params_products_list');
		$products->limit = 0; //sätter LIMIT = 0 så vi får med alla rows
		$products->load_sql();

		//inkluderar class-filen för exportering
		require($root_path.'includes/class_export.php');

		if ( $format == 'excel' )
		{
			$export = new ExcelExport();
		}
		elseif ( $format == 'csv' )
		{
			$export = new CSVExport();
		}
		elseif ( $format == 'text' )
		{
			$export = new OptiExport();
		}

		//hämtar kolumner från POST (enbart markerade kommer exporteras)
		$columns = array();
		$captions = array();
		foreach ($_POST['columns'] as $col)
		{
			$col = explode('|', $col);
			$columns[] = $col[0];
			$captions[] = $col[1];
		}
		unset($col);

		//skriver ut kolumnrubriker
		$export->addHeader($captions);

		//går igenom och skriver ut alla rader
		foreach ($products->rows as $r)
		{
			$data = array();
			foreach ($columns as $colname)
			{
				$data[] = $r[$colname];
			}
			unset($colname);

			$export->addRow($data);
		}
		unset($r);

		//sparar filen
		if ( $export->createFile($cfg->export_path) )
		{
			$tpl->assign_block_vars('step2', array(
				'ROW_COUNTER' => $export->row_counter,
				'EXPORT_PATH' => $cfg->export_path,
				'FILENAME' => $export->filename,
			));
		}
		else
		{
			die($export->error);
		}
	}
	//step1
	else
	{
		$tpl->assign_block_vars('step1', array());
	}

	$tpl->pparse('body');
}



//------------------------------------------------------------------------------
// Protokoll: List
//------------------------------------------------------------------------------
if ( $module == 'protocol' && $action == 'list' )
{
	$tpl->set_filenames(array('body' => 'protocol_list.tpl'));

	$protocol = new ProtocolTable();
	$protocol->url = $cfg->admin_base_filename.'?module=protocol&action=list';
	$protocol->load_params('params_protocol_list');
	$protocol->load_sql();

	foreach ($protocol->rows as $r)
	{
		$row_class = ( isset($row_class) && $row_class == 'row1' ) ? 'row2' : 'row1';
		$tpl->assign_block_vars('protocol', array(
			'ROW_CLASS' => $row_class,
			'ID' => OptiAdmin::view('int', $r['id'], 'id'),
			'SELECTION_DATE' => OptiAdmin::view('date', $r['selection_date'], 'selection_date'),
			'ORDER_NO' => OptiAdmin::view('text', $r['order_no'], 'order_no'),
			'INSTALLATORS_ORDERID' => OptiAdmin::view('text', $r['installators_orderid'], 'installators_orderid'),
			'CUSTOMER_NO' => OptiAdmin::view('text', $r['customer_no'], 'customer_no'),
			'LINE_VENDOR_NO' => OptiAdmin::view('text', $r['line_vendor_no'], 'line_vendor_no'),
			'CUSTOMER_NAME' => OptiAdmin::view('text', $r['customer_name'], 'customer_name'),
			'WANTED_DELIVERY_DATE' => OptiAdmin::view('date', $r['wanted_delivery_date'], 'wanted_delivery_date'),
			'REFERENCE' => OptiAdmin::view('text', $r['reference'], 'reference'),
			'CUSTOMER_PO_NO' => OptiAdmin::view('text', $r['customer_po_no'], 'customer_po_no'),
			'DATE_ENTERED' => OptiAdmin::view('datetime', $r['date_entered'], 'date_entered'),
			'COMPANY_NAME2' => OptiAdmin::view('text', $r['company_name2'], 'company_name2'),
			'ADDRESS1' => OptiAdmin::view('text', $r['address1'], 'address1'),
			'ADDRESS2' => OptiAdmin::view('text', $r['address2'], 'address2'),
			'COUNTY' => OptiAdmin::view('text', $r['county'], 'county'),
			'STATE' => OptiAdmin::view('text', $r['state'], 'state'),
			'COUNTRY_CODE' => OptiAdmin::view('text', $r['country_code'], 'country_code'),
			'COUNTRY' => OptiAdmin::view('text', $r['country'], 'country'),
			'INSTALLATIONS_DATUM' => OptiAdmin::view('date', $r['installations_datum'], 'installations_datum'),
			'ARBETSNUMMER' => OptiAdmin::view('text', $r['arbetsnummer'], 'arbetsnummer'),
			'ETAPP' => OptiAdmin::view('text', $r['etapp'], 'etapp'),
			'SING_INSTALLATOR' => OptiAdmin::view('text', $r['sing_installator'], 'sing_installator'),
			'SING_ARBETSLEDARE' => OptiAdmin::view('text', $r['sing_arbetsledare'], 'sing_arbetsledare'),
			'KONTROLL_CHECKLISTA' => OptiAdmin::view('bool', $r['kontroll_checklista'], 'kontroll_checklista'),
			'KOMMENTAR' => OptiAdmin::view('textarea', $r['kommentar'], 'kommentar'),
			'KONTAKT_PERSON' => OptiAdmin::view('text', $r['kontakt_person'], 'kontakt_person'),
			'PRODUKT_TG_CE_NUMMER' => OptiAdmin::view('text', $r['produkt_tg_ce_nummer'], 'produkt_tg_ce_nummer'),
			'PUBLICERAT' => OptiAdmin::view('bool', $r['publicerat'], 'publicerat'),
			'SORTORDER' => OptiAdmin::view('sort', $r['sortorder'], 'sortorder'),
			'ACTIVE' => OptiAdmin::view('bool', $r['active'], 'active'),
		));
	}
	unset($r);

	$tpl->assign_vars(array(
		'FILTER_SELECTION_DATE' => ( isset($protocol->filter['selection_date']) ) ? OptiAdmin::edit('filter_date', $protocol->filter['selection_date'], 'selection_date', true) : OptiAdmin::edit('filter_date', '', 'selection_date', true),
		'FILTER_WANTED_DELIVERY_DATE' => ( isset($protocol->filter['wanted_delivery_date']) ) ? OptiAdmin::edit('filter_date', $protocol->filter['wanted_delivery_date'], 'wanted_delivery_date', true) : OptiAdmin::edit('filter_date', '', 'wanted_delivery_date', true),
		'FILTER_DATE_ENTERED' => ( isset($protocol->filter['date_entered']) ) ? OptiAdmin::edit('filter_date', $protocol->filter['date_entered'], 'date_entered', true) : OptiAdmin::edit('filter_date', '', 'date_entered', true),
		'FILTER_INSTALLATIONS_DATUM' => ( isset($protocol->filter['installations_datum']) ) ? OptiAdmin::edit('filter_date', $protocol->filter['installations_datum'], 'installations_datum', true) : OptiAdmin::edit('filter_date', '', 'installations_datum', true),
		'FILTER_KONTROLL_CHECKLISTA' => ( isset($protocol->filter['kontroll_checklista']) ) ? OptiAdmin::edit('bool', $protocol->filter['kontroll_checklista'], 'kontroll_checklista', true) : OptiAdmin::edit('bool', '', 'kontroll_checklista', true),
		'FILTER_PUBLICERAT' => ( isset($protocol->filter['publicerat']) ) ? OptiAdmin::edit('bool', $protocol->filter['publicerat'], 'publicerat', true) : OptiAdmin::edit('bool', '', 'publicerat', true),
		'FILTER_ACTIVE' => ( isset($protocol->filter['active']) ) ? OptiAdmin::edit('bool', $protocol->filter['active'], 'active', true) : OptiAdmin::edit('bool', '', 'active', true),
		'SEARCH_STRING' => $protocol->search,
		'SORT_ID' => $protocol->create_sortable('id', 'Id'),
		'SORT_SELECTION_DATE' => $protocol->create_sortable('selection_date', 'Selection_date'),
		'SORT_ORDER_NO' => $protocol->create_sortable('order_no', 'Order_no'),
		'SORT_INSTALLATORS_ORDERID' => $protocol->create_sortable('installators_orderid', 'Installators_orderid'),
		'SORT_CUSTOMER_NO' => $protocol->create_sortable('customer_no', 'Customer_no'),
		'SORT_LINE_VENDOR_NO' => $protocol->create_sortable('line_vendor_no', 'Line_vendor_no'),
		'SORT_CUSTOMER_NAME' => $protocol->create_sortable('customer_name', 'Customer_name'),
		'SORT_WANTED_DELIVERY_DATE' => $protocol->create_sortable('wanted_delivery_date', 'Wanted_delivery_date'),
		'SORT_REFERENCE' => $protocol->create_sortable('reference', 'Reference'),
		'SORT_CUSTOMER_PO_NO' => $protocol->create_sortable('customer_po_no', 'Customer_po_no'),
		'SORT_DATE_ENTERED' => $protocol->create_sortable('date_entered', 'Date_entered'),
		'SORT_COMPANY_NAME2' => $protocol->create_sortable('company_name2', 'Company_name2'),
		'SORT_ADDRESS1' => $protocol->create_sortable('address1', 'Address1'),
		'SORT_ADDRESS2' => $protocol->create_sortable('address2', 'Address2'),
		'SORT_COUNTY' => $protocol->create_sortable('county', 'County'),
		'SORT_STATE' => $protocol->create_sortable('state', 'State'),
		'SORT_COUNTRY_CODE' => $protocol->create_sortable('country_code', 'Country_code'),
		'SORT_COUNTRY' => $protocol->create_sortable('country', 'Country'),
		'SORT_INSTALLATIONS_DATUM' => $protocol->create_sortable('installations_datum', 'Installations_datum'),
		'SORT_ARBETSNUMMER' => $protocol->create_sortable('arbetsnummer', 'Arbetsnummer'),
		'SORT_ETAPP' => $protocol->create_sortable('etapp', 'Etapp'),
		'SORT_SING_INSTALLATOR' => $protocol->create_sortable('sing_installator', 'Sing_installator'),
		'SORT_SING_ARBETSLEDARE' => $protocol->create_sortable('sing_arbetsledare', 'Sing_arbetsledare'),
		'SORT_KONTROLL_CHECKLISTA' => $protocol->create_sortable('kontroll_checklista', 'Kontroll_checklista'),
		'SORT_KOMMENTAR' => $protocol->create_sortable('kommentar', 'Kommentar'),
		'SORT_KONTAKT_PERSON' => $protocol->create_sortable('kontakt_person', 'Kontakt_person'),
		'SORT_PRODUKT_TG_CE_NUMMER' => $protocol->create_sortable('produkt_tg_ce_nummer', 'Produkt_tg_ce_nummer'),
		'SORT_PUBLICERAT' => $protocol->create_sortable('publicerat', 'Publicerat'),
		'SORT_SORTORDER' => $protocol->create_sortable('sortorder', 'Sortorder'),
		'SORT_ACTIVE' => $protocol->create_sortable('active', 'Active'),
		'FILTER_SEARCH_MESSAGE' => ( $protocol->filter_search_message ) ? '<div class="notice_box">'.$protocol->filter_search_message.'</div>' : '',
		'NUMROWS' => ( $protocol->antal < $protocol->found_rows ) ? '<div class="numrows">Visar '.$protocol->antal.' (av '.$protocol->found_rows.' st. totalt)</div>' : '<div class="numrows">'.$protocol->antal.' st. totalt</div>',
		'PAGENAV' => $protocol->create_pagenav(),
		'SORTERA' => ( $protocol->antal < $protocol->found_rows || $protocol->filter_search_message ) ? '<span class="icon_disabled_sort" title="Sortering enbart möjlig när alla rader visas">Sortera</span>' : '<span class="link icon_sort">Sortera</span>',
	));

	//om vi visar alla rader samtidigt (och ingen filtrering/sök): möjliggör sortering
	if ( $protocol->antal == $protocol->found_rows && !$protocol->filter_search_message )
	{
		$tpl->assign_block_vars('js_sortcol', array());
	}

	//sparar userdata (parametrar & id:s) i SESSION
	$user->data['id_list_protocol_list'] = $protocol->id_list;
	$user->save_data();

	$tpl->pparse('body');
}
//------------------------------------------------------------------------------
// Protokoll: View
//------------------------------------------------------------------------------
if ( $module == 'protocol' && $action == 'view' )
{
	$tpl->set_filenames(array('body' => 'protocol_view.tpl'));

	$protocol = new ProtocolRow();
	$protocol->url = $cfg->admin_base_filename.'?module=protocol&action=view';
	$protocol->url_up = $cfg->admin_base_filename.'?module=protocol&action=list';
	$protocol->id_from_get();
	$protocol->load_data();

	$tpl->assign_vars(array(
		'ID' => OptiAdmin::view('int', $protocol->data['id'], 'id'),
		'SELECTION_DATE' => OptiAdmin::view('date', $protocol->data['selection_date'], 'selection_date'),
		'ORDER_NO' => OptiAdmin::view('text', $protocol->data['order_no'], 'order_no'),
		'INSTALLATORS_ORDERID' => OptiAdmin::view('text', $protocol->data['installators_orderid'], 'installators_orderid'),
		'CUSTOMER_NO' => OptiAdmin::view('text', $protocol->data['customer_no'], 'customer_no'),
		'LINE_VENDOR_NO' => OptiAdmin::view('text', $protocol->data['line_vendor_no'], 'line_vendor_no'),
		'CUSTOMER_NAME' => OptiAdmin::view('text', $protocol->data['customer_name'], 'customer_name'),
		'WANTED_DELIVERY_DATE' => OptiAdmin::view('date', $protocol->data['wanted_delivery_date'], 'wanted_delivery_date'),
		'REFERENCE' => OptiAdmin::view('text', $protocol->data['reference'], 'reference'),
		'CUSTOMER_PO_NO' => OptiAdmin::view('text', $protocol->data['customer_po_no'], 'customer_po_no'),
		'DATE_ENTERED' => OptiAdmin::view('datetime', $protocol->data['date_entered'], 'date_entered'),
		'COMPANY_NAME2' => OptiAdmin::view('text', $protocol->data['company_name2'], 'company_name2'),
		'ADDRESS1' => OptiAdmin::view('text', $protocol->data['address1'], 'address1'),
		'ADDRESS2' => OptiAdmin::view('text', $protocol->data['address2'], 'address2'),
		'COUNTY' => OptiAdmin::view('text', $protocol->data['county'], 'county'),
		'STATE' => OptiAdmin::view('text', $protocol->data['state'], 'state'),
		'COUNTRY_CODE' => OptiAdmin::view('text', $protocol->data['country_code'], 'country_code'),
		'COUNTRY' => OptiAdmin::view('text', $protocol->data['country'], 'country'),
		'INSTALLATIONS_DATUM' => OptiAdmin::view('date', $protocol->data['installations_datum'], 'installations_datum'),
		'ARBETSNUMMER' => OptiAdmin::view('text', $protocol->data['arbetsnummer'], 'arbetsnummer'),
		'ETAPP' => OptiAdmin::view('text', $protocol->data['etapp'], 'etapp'),
		'SING_INSTALLATOR' => OptiAdmin::view('text', $protocol->data['sing_installator'], 'sing_installator'),
		'SING_ARBETSLEDARE' => OptiAdmin::view('text', $protocol->data['sing_arbetsledare'], 'sing_arbetsledare'),
		'KONTROLL_CHECKLISTA' => OptiAdmin::view('bool', $protocol->data['kontroll_checklista'], 'kontroll_checklista'),
		'KOMMENTAR' => OptiAdmin::view('textarea', $protocol->data['kommentar'], 'kommentar'),
		'KONTAKT_PERSON' => OptiAdmin::view('text', $protocol->data['kontakt_person'], 'kontakt_person'),
		'PRODUKT_TG_CE_NUMMER' => OptiAdmin::view('text', $protocol->data['produkt_tg_ce_nummer'], 'produkt_tg_ce_nummer'),
		'PUBLICERAT' => OptiAdmin::view('bool', $protocol->data['publicerat'], 'publicerat'),
		'SORTORDER' => OptiAdmin::view('sort', $protocol->data['sortorder'], 'sortorder'),
		'ACTIVE' => OptiAdmin::view('bool', $protocol->data['active'], 'active'),
		'NAVBAR' => $protocol->create_navbar('id_list_protocol_list'),
	));

	$tpl->pparse('body');
}
//------------------------------------------------------------------------------
// Protokoll: Add
//------------------------------------------------------------------------------
if ( $module == 'protocol' && $action == 'add' )
{
	$tpl->set_filenames(array('body' => 'protocol_add.tpl'));

	$protocol = new ProtocolRow();

	$tpl->assign_vars(array(
		'INPUT_SELECTION_DATE' => OptiAdmin::edit('date', NULL, 'selection_date'),
		'INPUT_ORDER_NO' => OptiAdmin::edit('text', NULL, 'order_no'),
		'INPUT_INSTALLATORS_ORDERID' => OptiAdmin::edit('text', NULL, 'installators_orderid'),
		'INPUT_CUSTOMER_NO' => OptiAdmin::edit('text', NULL, 'customer_no'),
		'INPUT_LINE_VENDOR_NO' => OptiAdmin::edit('text', NULL, 'line_vendor_no'),
		'INPUT_CUSTOMER_NAME' => OptiAdmin::edit('text', NULL, 'customer_name'),
		'INPUT_WANTED_DELIVERY_DATE' => OptiAdmin::edit('date', NULL, 'wanted_delivery_date'),
		'INPUT_REFERENCE' => OptiAdmin::edit('text', NULL, 'reference'),
		'INPUT_CUSTOMER_PO_NO' => OptiAdmin::edit('text', NULL, 'customer_po_no'),
		'INPUT_DATE_ENTERED' => OptiAdmin::edit('datetime', NULL, 'date_entered'),
		'INPUT_COMPANY_NAME2' => OptiAdmin::edit('text', NULL, 'company_name2'),
		'INPUT_ADDRESS1' => OptiAdmin::edit('text', NULL, 'address1'),
		'INPUT_ADDRESS2' => OptiAdmin::edit('text', NULL, 'address2'),
		'INPUT_COUNTY' => OptiAdmin::edit('text', NULL, 'county'),
		'INPUT_STATE' => OptiAdmin::edit('text', NULL, 'state'),
		'INPUT_COUNTRY_CODE' => OptiAdmin::edit('text', NULL, 'country_code'),
		'INPUT_COUNTRY' => OptiAdmin::edit('text', NULL, 'country'),
		'INPUT_INSTALLATIONS_DATUM' => OptiAdmin::edit('date', NULL, 'installations_datum'),
		'INPUT_ARBETSNUMMER' => OptiAdmin::edit('text', NULL, 'arbetsnummer'),
		'INPUT_ETAPP' => OptiAdmin::edit('text', NULL, 'etapp'),
		'INPUT_SING_INSTALLATOR' => OptiAdmin::edit('text', NULL, 'sing_installator'),
		'INPUT_SING_ARBETSLEDARE' => OptiAdmin::edit('text', NULL, 'sing_arbetsledare'),
		'INPUT_KONTROLL_CHECKLISTA' => OptiAdmin::edit('bool', NULL, 'kontroll_checklista'),
		'INPUT_KOMMENTAR' => OptiAdmin::edit('textarea', NULL, 'kommentar'),
		'INPUT_KONTAKT_PERSON' => OptiAdmin::edit('text', NULL, 'kontakt_person'),
		'INPUT_PRODUKT_TG_CE_NUMMER' => OptiAdmin::edit('text', NULL, 'produkt_tg_ce_nummer'),
		'INPUT_PUBLICERAT' => OptiAdmin::edit('bool', NULL, 'publicerat'),
		'INPUT_SORTORDER' => OptiAdmin::edit('sort', NULL, 'sortorder'),
		'INPUT_ACTIVE' => OptiAdmin::edit('bool', NULL, 'active'),
	));

	$tpl->pparse('body');
}
//------------------------------------------------------------------------------
// Protokoll: Edit
//------------------------------------------------------------------------------
if ( $module == 'protocol' && $action == 'edit' )
{
	$tpl->set_filenames(array('body' => 'protocol_edit.tpl'));

	$protocol = new ProtocolRow();
	$protocol->url = $cfg->admin_base_filename.'?module=protocol&action=edit';
	$protocol->url_up = $cfg->admin_base_filename.'?module=protocol&action=list';
	$protocol->id_from_get();
	$protocol->load_data();

	$tpl->assign_vars(array(
		'ID' => $protocol->id,
		'INPUT_SELECTION_DATE' => OptiAdmin::edit('date', $protocol->data['selection_date'], 'selection_date'),
		'INPUT_ORDER_NO' => OptiAdmin::edit('text', $protocol->data['order_no'], 'order_no'),
		'INPUT_INSTALLATORS_ORDERID' => OptiAdmin::edit('text', $protocol->data['installators_orderid'], 'installators_orderid'),
		'INPUT_CUSTOMER_NO' => OptiAdmin::edit('text', $protocol->data['customer_no'], 'customer_no'),
		'INPUT_LINE_VENDOR_NO' => OptiAdmin::edit('text', $protocol->data['line_vendor_no'], 'line_vendor_no'),
		'INPUT_CUSTOMER_NAME' => OptiAdmin::edit('text', $protocol->data['customer_name'], 'customer_name'),
		'INPUT_WANTED_DELIVERY_DATE' => OptiAdmin::edit('date', $protocol->data['wanted_delivery_date'], 'wanted_delivery_date'),
		'INPUT_REFERENCE' => OptiAdmin::edit('text', $protocol->data['reference'], 'reference'),
		'INPUT_CUSTOMER_PO_NO' => OptiAdmin::edit('text', $protocol->data['customer_po_no'], 'customer_po_no'),
		'INPUT_DATE_ENTERED' => OptiAdmin::edit('datetime', $protocol->data['date_entered'], 'date_entered'),
		'INPUT_COMPANY_NAME2' => OptiAdmin::edit('text', $protocol->data['company_name2'], 'company_name2'),
		'INPUT_ADDRESS1' => OptiAdmin::edit('text', $protocol->data['address1'], 'address1'),
		'INPUT_ADDRESS2' => OptiAdmin::edit('text', $protocol->data['address2'], 'address2'),
		'INPUT_COUNTY' => OptiAdmin::edit('text', $protocol->data['county'], 'county'),
		'INPUT_STATE' => OptiAdmin::edit('text', $protocol->data['state'], 'state'),
		'INPUT_COUNTRY_CODE' => OptiAdmin::edit('text', $protocol->data['country_code'], 'country_code'),
		'INPUT_COUNTRY' => OptiAdmin::edit('text', $protocol->data['country'], 'country'),
		'INPUT_INSTALLATIONS_DATUM' => OptiAdmin::edit('date', $protocol->data['installations_datum'], 'installations_datum'),
		'INPUT_ARBETSNUMMER' => OptiAdmin::edit('text', $protocol->data['arbetsnummer'], 'arbetsnummer'),
		'INPUT_ETAPP' => OptiAdmin::edit('text', $protocol->data['etapp'], 'etapp'),
		'INPUT_SING_INSTALLATOR' => OptiAdmin::edit('text', $protocol->data['sing_installator'], 'sing_installator'),
		'INPUT_SING_ARBETSLEDARE' => OptiAdmin::edit('text', $protocol->data['sing_arbetsledare'], 'sing_arbetsledare'),
		'INPUT_KONTROLL_CHECKLISTA' => OptiAdmin::edit('bool', $protocol->data['kontroll_checklista'], 'kontroll_checklista'),
		'INPUT_KOMMENTAR' => OptiAdmin::edit('textarea', $protocol->data['kommentar'], 'kommentar'),
		'INPUT_KONTAKT_PERSON' => OptiAdmin::edit('text', $protocol->data['kontakt_person'], 'kontakt_person'),
		'INPUT_PRODUKT_TG_CE_NUMMER' => OptiAdmin::edit('text', $protocol->data['produkt_tg_ce_nummer'], 'produkt_tg_ce_nummer'),
		'INPUT_PUBLICERAT' => OptiAdmin::edit('bool', $protocol->data['publicerat'], 'publicerat'),
		'INPUT_SORTORDER' => OptiAdmin::edit('sort', $protocol->data['sortorder'], 'sortorder'),
		'INPUT_ACTIVE' => OptiAdmin::edit('bool', $protocol->data['active'], 'active'),
		'NAVBAR' => $protocol->create_navbar('id_list_protocol_list'),
		'SUBMIT_SAVE_NEXT_ID' => ( $protocol->next_id ) ? '<button type="submit" name="submit_save_next_id" value="'.$protocol->next_id.'"><img src="images/icon_save_next.png" /> Spara/nästa</button>&nbsp;&nbsp;' : '',
	));

	$tpl->pparse('body');
}
//------------------------------------------------------------------------------
// Protokoll: Export
//------------------------------------------------------------------------------
if ( $module == 'protocol' && $action == 'export' )
{
	$tpl->set_filenames(array('body' => 'protocol_export.tpl'));

	//step2
	if ( isset($_POST['format']) && in_array($_POST['format'], array('excel', 'csv', 'text')) && isset($_POST['columns']) && count($_POST['columns']) > 0 )
	{
		$format = $_POST['format'];

		//hämtar data
		$protocol = new ProtocolTable();
		$protocol->url = $cfg->admin_base_filename.'?module=protocol&action=export';
		$protocol->load_params('params_protocol_list');
		$protocol->limit = 0; //sätter LIMIT = 0 så vi får med alla rows
		$protocol->load_sql();

		//inkluderar class-filen för exportering
		require($root_path.'includes/class_export.php');

		if ( $format == 'excel' )
		{
			$export = new ExcelExport();
		}
		elseif ( $format == 'csv' )
		{
			$export = new CSVExport();
		}
		elseif ( $format == 'text' )
		{
			$export = new OptiExport();
		}

		//hämtar kolumner från POST (enbart markerade kommer exporteras)
		$columns = array();
		$captions = array();
		foreach ($_POST['columns'] as $col)
		{
			$col = explode('|', $col);
			$columns[] = $col[0];
			$captions[] = $col[1];
		}
		unset($col);

		//skriver ut kolumnrubriker
		$export->addHeader($captions);

		//går igenom och skriver ut alla rader
		foreach ($protocol->rows as $r)
		{
			$data = array();
			foreach ($columns as $colname)
			{
				$data[] = $r[$colname];
			}
			unset($colname);

			$export->addRow($data);
		}
		unset($r);

		//sparar filen
		if ( $export->createFile($cfg->export_path) )
		{
			$tpl->assign_block_vars('step2', array(
				'ROW_COUNTER' => $export->row_counter,
				'EXPORT_PATH' => $cfg->export_path,
				'FILENAME' => $export->filename,
			));
		}
		else
		{
			die($export->error);
		}
	}
	//step1
	else
	{
		$tpl->assign_block_vars('step1', array());
	}

	$tpl->pparse('body');
}



//------------------------------------------------------------------------------
// Ytor: List
//------------------------------------------------------------------------------
if ( $module == 'surfaces' && $action == 'list' )
{
	$tpl->set_filenames(array('body' => 'surfaces_list.tpl'));

	$surfaces = new SurfacesTable();
	$surfaces->url = $cfg->admin_base_filename.'?module=surfaces&action=list';
	$surfaces->load_params('params_surfaces_list');
	$surfaces->load_sql();

	foreach ($surfaces->rows as $r)
	{
		$row_class = ( isset($row_class) && $row_class == 'row1' ) ? 'row2' : 'row1';
		$tpl->assign_block_vars('surfaces', array(
			'ROW_CLASS' => $row_class,
			'ID' => OptiAdmin::view('int', $r['id'], 'id'),
			'PROKOLL_ID_FOREIGN' => OptiAdmin::view('foreign', $r['prokoll_id_foreign'], 'prokoll_id'),
			'TYP_ID' => OptiAdmin::view('int', $r['typ_id'], 'typ_id'),
			'BEST_YTA' => OptiAdmin::view('float', $r['best_yta'], 'best_yta'),
			'BEST_TJOCKLEK' => OptiAdmin::view('float', $r['best_tjocklek'], 'best_tjocklek'),
			'YTAN' => OptiAdmin::view('float', $r['ytan'], 'ytan'),
			'TJOCKLEK' => OptiAdmin::view('float', $r['tjocklek'], 'tjocklek'),
			'PRODUKT_NAMN' => OptiAdmin::view('text', $r['produkt_namn'], 'produkt_namn'),
			'SACKVIKT' => OptiAdmin::view('float', $r['sackvikt'], 'sackvikt'),
			'SATTNING' => OptiAdmin::view('float', $r['sattning'], 'sattning'),
			'MIN_DENSITET' => OptiAdmin::view('float', $r['min_densitet'], 'min_densitet'),
			'LINE_CATALOG_DESC' => OptiAdmin::view('text', $r['line_catalog_desc'], 'line_catalog_desc'),
			'LINE_VENDOR_NO' => OptiAdmin::view('text', $r['line_vendor_no'], 'line_vendor_no'),
			'LINE_AREA_AND_SIZE' => OptiAdmin::view('text', $r['line_area_and_size'], 'line_area_and_size'),
			'ANTAL_SACK_VERKLIG' => OptiAdmin::view('int', $r['antal_sack_verklig'], 'antal_sack_verklig'),
			'ANTAL_SACK_BERAKNAD' => OptiAdmin::view('int', $r['antal_sack_beraknad'], 'antal_sack_beraknad'),
			'LAMBDA' => OptiAdmin::view('float', $r['lambda'], 'lambda'),
			'ISPAROCPRODUKT' => OptiAdmin::view('bool', $r['isparocprodukt'], 'isparocprodukt'),
			'SACK_KUBIK' => OptiAdmin::view('float', $r['sack_kubik'], 'sack_kubik'),
			'SORTORDER' => OptiAdmin::view('sort', $r['sortorder'], 'sortorder'),
			'ACTIVE' => OptiAdmin::view('bool', $r['active'], 'active'),
		));
	}
	unset($r);

	$tpl->assign_vars(array(
		'FILTER_PROKOLL_ID' => ( isset($surfaces->filter['prokoll_id']) ) ? OptiAdmin::edit('foreign', $surfaces->filter['prokoll_id'], 'prokoll_id', true) : OptiAdmin::edit('foreign', '', 'prokoll_id', true),
		'FILTER_ISPAROCPRODUKT' => ( isset($surfaces->filter['isparocprodukt']) ) ? OptiAdmin::edit('bool', $surfaces->filter['isparocprodukt'], 'isparocprodukt', true) : OptiAdmin::edit('bool', '', 'isparocprodukt', true),
		'FILTER_ACTIVE' => ( isset($surfaces->filter['active']) ) ? OptiAdmin::edit('bool', $surfaces->filter['active'], 'active', true) : OptiAdmin::edit('bool', '', 'active', true),
		'SEARCH_STRING' => $surfaces->search,
		'SORT_ID' => $surfaces->create_sortable('id', 'Id'),
		'SORT_PROKOLL_ID' => $surfaces->create_sortable('prokoll_id', 'Prokoll_id'),
		'SORT_TYP_ID' => $surfaces->create_sortable('typ_id', 'Typ_id'),
		'SORT_BEST_YTA' => $surfaces->create_sortable('best_yta', 'Best_yta'),
		'SORT_BEST_TJOCKLEK' => $surfaces->create_sortable('best_tjocklek', 'Best_tjocklek'),
		'SORT_YTAN' => $surfaces->create_sortable('ytan', 'Ytan'),
		'SORT_TJOCKLEK' => $surfaces->create_sortable('tjocklek', 'Tjocklek'),
		'SORT_PRODUKT_NAMN' => $surfaces->create_sortable('produkt_namn', 'Produkt_namn'),
		'SORT_SACKVIKT' => $surfaces->create_sortable('sackvikt', 'Sackvikt'),
		'SORT_SATTNING' => $surfaces->create_sortable('sattning', 'Sattning'),
		'SORT_MIN_DENSITET' => $surfaces->create_sortable('min_densitet', 'Min_densitet'),
		'SORT_LINE_CATALOG_DESC' => $surfaces->create_sortable('line_catalog_desc', 'Line_catalog_desc'),
		'SORT_LINE_VENDOR_NO' => $surfaces->create_sortable('line_vendor_no', 'Line_vendor_no'),
		'SORT_LINE_AREA_AND_SIZE' => $surfaces->create_sortable('line_area_and_size', 'Line_area_and_size'),
		'SORT_ANTAL_SACK_VERKLIG' => $surfaces->create_sortable('antal_sack_verklig', 'Antal_sack_verklig'),
		'SORT_ANTAL_SACK_BERAKNAD' => $surfaces->create_sortable('antal_sack_beraknad', 'Antal_sack_beraknad'),
		'SORT_LAMBDA' => $surfaces->create_sortable('lambda', 'Lambda'),
		'SORT_ISPAROCPRODUKT' => $surfaces->create_sortable('isparocprodukt', 'Isparocprodukt'),
		'SORT_SACK_KUBIK' => $surfaces->create_sortable('sack_kubik', 'Sack_kubik'),
		'SORT_SORTORDER' => $surfaces->create_sortable('sortorder', 'Sortorder'),
		'SORT_ACTIVE' => $surfaces->create_sortable('active', 'Active'),
		'FILTER_SEARCH_MESSAGE' => ( $surfaces->filter_search_message ) ? '<div class="notice_box">'.$surfaces->filter_search_message.'</div>' : '',
		'NUMROWS' => ( $surfaces->antal < $surfaces->found_rows ) ? '<div class="numrows">Visar '.$surfaces->antal.' (av '.$surfaces->found_rows.' st. totalt)</div>' : '<div class="numrows">'.$surfaces->antal.' st. totalt</div>',
		'PAGENAV' => $surfaces->create_pagenav(),
		'SORTERA' => ( $surfaces->antal < $surfaces->found_rows || $surfaces->filter_search_message ) ? '<span class="icon_disabled_sort" title="Sortering enbart möjlig när alla rader visas">Sortera</span>' : '<span class="link icon_sort">Sortera</span>',
	));

	//om vi visar alla rader samtidigt (och ingen filtrering/sök): möjliggör sortering
	if ( $surfaces->antal == $surfaces->found_rows && !$surfaces->filter_search_message )
	{
		$tpl->assign_block_vars('js_sortcol', array());
	}

	//sparar userdata (parametrar & id:s) i SESSION
	$user->data['id_list_surfaces_list'] = $surfaces->id_list;
	$user->save_data();

	$tpl->pparse('body');
}
//------------------------------------------------------------------------------
// Ytor: View
//------------------------------------------------------------------------------
if ( $module == 'surfaces' && $action == 'view' )
{
	$tpl->set_filenames(array('body' => 'surfaces_view.tpl'));

	$surfaces = new SurfacesRow();
	$surfaces->url = $cfg->admin_base_filename.'?module=surfaces&action=view';
	$surfaces->url_up = $cfg->admin_base_filename.'?module=surfaces&action=list';
	$surfaces->id_from_get();
	$surfaces->load_data();

	$tpl->assign_vars(array(
		'ID' => OptiAdmin::view('int', $surfaces->data['id'], 'id'),
		'PROKOLL_ID_FOREIGN' => OptiAdmin::view('foreign', $surfaces->data['prokoll_id_foreign'], 'prokoll_id'),
		'TYP_ID' => OptiAdmin::view('int', $surfaces->data['typ_id'], 'typ_id'),
		'BEST_YTA' => OptiAdmin::view('float', $surfaces->data['best_yta'], 'best_yta'),
		'BEST_TJOCKLEK' => OptiAdmin::view('float', $surfaces->data['best_tjocklek'], 'best_tjocklek'),
		'YTAN' => OptiAdmin::view('float', $surfaces->data['ytan'], 'ytan'),
		'TJOCKLEK' => OptiAdmin::view('float', $surfaces->data['tjocklek'], 'tjocklek'),
		'PRODUKT_NAMN' => OptiAdmin::view('text', $surfaces->data['produkt_namn'], 'produkt_namn'),
		'SACKVIKT' => OptiAdmin::view('float', $surfaces->data['sackvikt'], 'sackvikt'),
		'SATTNING' => OptiAdmin::view('float', $surfaces->data['sattning'], 'sattning'),
		'MIN_DENSITET' => OptiAdmin::view('float', $surfaces->data['min_densitet'], 'min_densitet'),
		'LINE_CATALOG_DESC' => OptiAdmin::view('text', $surfaces->data['line_catalog_desc'], 'line_catalog_desc'),
		'LINE_VENDOR_NO' => OptiAdmin::view('text', $surfaces->data['line_vendor_no'], 'line_vendor_no'),
		'LINE_AREA_AND_SIZE' => OptiAdmin::view('text', $surfaces->data['line_area_and_size'], 'line_area_and_size'),
		'ANTAL_SACK_VERKLIG' => OptiAdmin::view('int', $surfaces->data['antal_sack_verklig'], 'antal_sack_verklig'),
		'ANTAL_SACK_BERAKNAD' => OptiAdmin::view('int', $surfaces->data['antal_sack_beraknad'], 'antal_sack_beraknad'),
		'LAMBDA' => OptiAdmin::view('float', $surfaces->data['lambda'], 'lambda'),
		'ISPAROCPRODUKT' => OptiAdmin::view('bool', $surfaces->data['isparocprodukt'], 'isparocprodukt'),
		'SACK_KUBIK' => OptiAdmin::view('float', $surfaces->data['sack_kubik'], 'sack_kubik'),
		'SORTORDER' => OptiAdmin::view('sort', $surfaces->data['sortorder'], 'sortorder'),
		'ACTIVE' => OptiAdmin::view('bool', $surfaces->data['active'], 'active'),
		'NAVBAR' => $surfaces->create_navbar('id_list_surfaces_list'),
	));

	$tpl->pparse('body');
}
//------------------------------------------------------------------------------
// Ytor: Add
//------------------------------------------------------------------------------
if ( $module == 'surfaces' && $action == 'add' )
{
	$tpl->set_filenames(array('body' => 'surfaces_add.tpl'));

	$surfaces = new SurfacesRow();

	$tpl->assign_vars(array(
		'INPUT_PROKOLL_ID' => OptiAdmin::edit('foreign', NULL, 'prokoll_id'),
		'INPUT_TYP_ID' => OptiAdmin::edit('int', NULL, 'typ_id'),
		'INPUT_BEST_YTA' => OptiAdmin::edit('float', NULL, 'best_yta'),
		'INPUT_BEST_TJOCKLEK' => OptiAdmin::edit('float', NULL, 'best_tjocklek'),
		'INPUT_YTAN' => OptiAdmin::edit('float', NULL, 'ytan'),
		'INPUT_TJOCKLEK' => OptiAdmin::edit('float', NULL, 'tjocklek'),
		'INPUT_PRODUKT_NAMN' => OptiAdmin::edit('text', NULL, 'produkt_namn'),
		'INPUT_SACKVIKT' => OptiAdmin::edit('float', NULL, 'sackvikt'),
		'INPUT_SATTNING' => OptiAdmin::edit('float', NULL, 'sattning'),
		'INPUT_MIN_DENSITET' => OptiAdmin::edit('float', NULL, 'min_densitet'),
		'INPUT_LINE_CATALOG_DESC' => OptiAdmin::edit('text', NULL, 'line_catalog_desc'),
		'INPUT_LINE_VENDOR_NO' => OptiAdmin::edit('text', NULL, 'line_vendor_no'),
		'INPUT_LINE_AREA_AND_SIZE' => OptiAdmin::edit('text', NULL, 'line_area_and_size'),
		'INPUT_ANTAL_SACK_VERKLIG' => OptiAdmin::edit('int', NULL, 'antal_sack_verklig'),
		'INPUT_ANTAL_SACK_BERAKNAD' => OptiAdmin::edit('int', NULL, 'antal_sack_beraknad'),
		'INPUT_LAMBDA' => OptiAdmin::edit('float', NULL, 'lambda'),
		'INPUT_ISPAROCPRODUKT' => OptiAdmin::edit('bool', NULL, 'isparocprodukt'),
		'INPUT_SACK_KUBIK' => OptiAdmin::edit('float', NULL, 'sack_kubik'),
		'INPUT_SORTORDER' => OptiAdmin::edit('sort', NULL, 'sortorder'),
		'INPUT_ACTIVE' => OptiAdmin::edit('bool', NULL, 'active'),
	));

	$tpl->pparse('body');
}
//------------------------------------------------------------------------------
// Ytor: Edit
//------------------------------------------------------------------------------
if ( $module == 'surfaces' && $action == 'edit' )
{
	$tpl->set_filenames(array('body' => 'surfaces_edit.tpl'));

	$surfaces = new SurfacesRow();
	$surfaces->url = $cfg->admin_base_filename.'?module=surfaces&action=edit';
	$surfaces->url_up = $cfg->admin_base_filename.'?module=surfaces&action=list';
	$surfaces->id_from_get();
	$surfaces->load_data();

	$tpl->assign_vars(array(
		'ID' => $surfaces->id,
		'INPUT_PROKOLL_ID' => OptiAdmin::edit('foreign', $surfaces->data['prokoll_id'], 'prokoll_id'),
		'INPUT_TYP_ID' => OptiAdmin::edit('int', $surfaces->data['typ_id'], 'typ_id'),
		'INPUT_BEST_YTA' => OptiAdmin::edit('float', $surfaces->data['best_yta'], 'best_yta'),
		'INPUT_BEST_TJOCKLEK' => OptiAdmin::edit('float', $surfaces->data['best_tjocklek'], 'best_tjocklek'),
		'INPUT_YTAN' => OptiAdmin::edit('float', $surfaces->data['ytan'], 'ytan'),
		'INPUT_TJOCKLEK' => OptiAdmin::edit('float', $surfaces->data['tjocklek'], 'tjocklek'),
		'INPUT_PRODUKT_NAMN' => OptiAdmin::edit('text', $surfaces->data['produkt_namn'], 'produkt_namn'),
		'INPUT_SACKVIKT' => OptiAdmin::edit('float', $surfaces->data['sackvikt'], 'sackvikt'),
		'INPUT_SATTNING' => OptiAdmin::edit('float', $surfaces->data['sattning'], 'sattning'),
		'INPUT_MIN_DENSITET' => OptiAdmin::edit('float', $surfaces->data['min_densitet'], 'min_densitet'),
		'INPUT_LINE_CATALOG_DESC' => OptiAdmin::edit('text', $surfaces->data['line_catalog_desc'], 'line_catalog_desc'),
		'INPUT_LINE_VENDOR_NO' => OptiAdmin::edit('text', $surfaces->data['line_vendor_no'], 'line_vendor_no'),
		'INPUT_LINE_AREA_AND_SIZE' => OptiAdmin::edit('text', $surfaces->data['line_area_and_size'], 'line_area_and_size'),
		'INPUT_ANTAL_SACK_VERKLIG' => OptiAdmin::edit('int', $surfaces->data['antal_sack_verklig'], 'antal_sack_verklig'),
		'INPUT_ANTAL_SACK_BERAKNAD' => OptiAdmin::edit('int', $surfaces->data['antal_sack_beraknad'], 'antal_sack_beraknad'),
		'INPUT_LAMBDA' => OptiAdmin::edit('float', $surfaces->data['lambda'], 'lambda'),
		'INPUT_ISPAROCPRODUKT' => OptiAdmin::edit('bool', $surfaces->data['isparocprodukt'], 'isparocprodukt'),
		'INPUT_SACK_KUBIK' => OptiAdmin::edit('float', $surfaces->data['sack_kubik'], 'sack_kubik'),
		'INPUT_SORTORDER' => OptiAdmin::edit('sort', $surfaces->data['sortorder'], 'sortorder'),
		'INPUT_ACTIVE' => OptiAdmin::edit('bool', $surfaces->data['active'], 'active'),
		'NAVBAR' => $surfaces->create_navbar('id_list_surfaces_list'),
		'SUBMIT_SAVE_NEXT_ID' => ( $surfaces->next_id ) ? '<button type="submit" name="submit_save_next_id" value="'.$surfaces->next_id.'"><img src="images/icon_save_next.png" /> Spara/nästa</button>&nbsp;&nbsp;' : '',
	));

	$tpl->pparse('body');
}
//------------------------------------------------------------------------------
// Ytor: Export
//------------------------------------------------------------------------------
if ( $module == 'surfaces' && $action == 'export' )
{
	$tpl->set_filenames(array('body' => 'surfaces_export.tpl'));

	//step2
	if ( isset($_POST['format']) && in_array($_POST['format'], array('excel', 'csv', 'text')) && isset($_POST['columns']) && count($_POST['columns']) > 0 )
	{
		$format = $_POST['format'];

		//hämtar data
		$surfaces = new SurfacesTable();
		$surfaces->url = $cfg->admin_base_filename.'?module=surfaces&action=export';
		$surfaces->load_params('params_surfaces_list');
		$surfaces->limit = 0; //sätter LIMIT = 0 så vi får med alla rows
		$surfaces->load_sql();

		//inkluderar class-filen för exportering
		require($root_path.'includes/class_export.php');

		if ( $format == 'excel' )
		{
			$export = new ExcelExport();
		}
		elseif ( $format == 'csv' )
		{
			$export = new CSVExport();
		}
		elseif ( $format == 'text' )
		{
			$export = new OptiExport();
		}

		//hämtar kolumner från POST (enbart markerade kommer exporteras)
		$columns = array();
		$captions = array();
		foreach ($_POST['columns'] as $col)
		{
			$col = explode('|', $col);
			$columns[] = $col[0];
			$captions[] = $col[1];
		}
		unset($col);

		//skriver ut kolumnrubriker
		$export->addHeader($captions);

		//går igenom och skriver ut alla rader
		foreach ($surfaces->rows as $r)
		{
			$data = array();
			foreach ($columns as $colname)
			{
				$data[] = $r[$colname];
			}
			unset($colname);

			$export->addRow($data);
		}
		unset($r);

		//sparar filen
		if ( $export->createFile($cfg->export_path) )
		{
			$tpl->assign_block_vars('step2', array(
				'ROW_COUNTER' => $export->row_counter,
				'EXPORT_PATH' => $cfg->export_path,
				'FILENAME' => $export->filename,
			));
		}
		else
		{
			die($export->error);
		}
	}
	//step1
	else
	{
		$tpl->assign_block_vars('step1', array());
	}

	$tpl->pparse('body');
}



//------------------------------------------------------------------------------
// Generera FOOTER
//------------------------------------------------------------------------------
include($root_path.'templates_'.$language.'/footer.tpl');

?>
