/*--------- Allmänt ----------------------------------------------------------*/

/*
globala variabler:
	base_filename;	//ex: 'optiadmin.php'
*/

window.addEvent('domready', function() {

	MooTools.lang.setLanguage("sv-SE");

	update_lightboxes();

});

function ajax_loading()
{
	//$('status').addClass('ajax-loading');
	//$('status').removeClass('ajax-idle');
}
function ajax_idle()
{
	//$('status').addClass('ajax-idle');
	//$('status').removeClass('ajax-loading');
}

function checkme(el)
{
	el.toggleClass('checked');
}

//------------------------------------------------------------------------------
// Gör ett AJAX-kall till url: base_filename+url_params och uppdaterar $(update_div) med svaret 
//------------------------------------------------------------------------------
function load_ajax(update_div, url_params) {
	ajax_loading();
	var ajax = new Request.HTML({
		url: base_filename+url_params,
		update: $(update_div),
		onSuccess: function(response) {
			ajax_idle();
			update_lightboxes();
		}
	}).get();
	return false; //så vi kan köra <a href="#" onclick="return func();">
}

//------------------------------------------------------------------------------
// Bekräftar borttagning, öppnar sedan url: base_filename+url_params
//------------------------------------------------------------------------------
function confirm_delete(url_params) {
	var input_box = confirm('Är du säker på att du vill ta bort den här raden?');
	if (input_box === true) {
		location.href = base_filename+url_params;
	}
	return false; //så vi kan köra <a href="#" onclick="return func();">
}
//------------------------------------------------------------------------------
// Bekräftar borttagning, skickar sedan vidare till load_ajax(update_div, url_params)
//------------------------------------------------------------------------------
function confirm_delete_ajax(update_div, url_params) {
	var input_box = confirm('Är du säker på att du vill ta bort den här raden?');
	if (input_box === true) {
		load_ajax(update_div, url_params);
	}
	return false; //så vi kan köra <a href="#" onclick="return func();">
}
//------------------------------------------------------------------------------
// Skapar en sorteringsbar lista
//------------------------------------------------------------------------------
function create_sortable(sortable_elements, table, primary_key, sortcol) {
	var MySort = new Sortables(sortable_elements, {
		//clone: true,
		handle: '.icon_sort',
		opacity: 0.5,
		onComplete: function() {
			var order = this.serialize();
			ajax_loading();
			var ajax = new Request.HTML({
				url: base_filename+'?module=index&action=sort_table',
				onSuccess: function(responseTree, responseElements, responseHTML, responseJavaScript) {
					ajax_idle();
					if ( responseHTML !== 'ok' ) {
						alert(responseHTML);
					}
				}
			}).post({
				'table': table,
				'primary_key': primary_key,
				'sortcol': sortcol,
				'order': order
			});
		}
	});
}

function create_datepicker(input_id, range) {
	if ( !range ) {
		var cal = new CalendarEightysix('datepicker_'+input_id, {
			'prefill': false,
			'startMonday': true,
			'format': '%Y-%m-%d',
			'toggler': 'datepicker_'+input_id+'_toggler',
			'alignX': 'middle',
			'offsetX': 0,
			'offsetY': 25
		});
	} else {
		var calStart = new CalendarEightysix('datepicker_'+input_id+'_start', {
			'prefill': false,
			'startMonday': true,
			'format': '%Y-%m-%d',
			'toggler': 'datepicker_'+input_id+'_start_toggler',
			'alignX': 'middle',
			'offsetX': 0,
			'offsetY': 25
		});
		calStart.addEvent('change', function(date) {
			$('datepicker_'+input_id+'_start').fireEvent('change');
		});
		$('datepicker_'+input_id+'_start').addEvent('change', function() {
			var date_start = $('datepicker_'+input_id+'_start').get('value');
			var date_end = $('datepicker_'+input_id+'_end').get('value');
			$('datepicker_'+input_id).set('value', date_start+' - '+date_end);
		});
		var calEnd = new CalendarEightysix('datepicker_'+input_id+'_end', {
			'prefill': false,
			'startMonday': true,
			'format': '%Y-%m-%d',
			'toggler': 'datepicker_'+input_id+'_end_toggler',
			'alignX': 'middle',
			'offsetX': 0,
			'offsetY': 25
		});
		calEnd.addEvent('change', function(date) {
			$('datepicker_'+input_id+'_end').fireEvent('change');
		});
		$('datepicker_'+input_id+'_end').addEvent('change', function() {
			var date_start = $('datepicker_'+input_id+'_start').get('value');
			var date_end = $('datepicker_'+input_id+'_end').get('value');
			$('datepicker_'+input_id).set('value', date_start+' - '+date_end);
		});
	}
}

//------------------------------------------------------------------------------
// Öppnar en lightbox med karta för att söka efter geoposition (iFrame) 
//------------------------------------------------------------------------------
function open_geoposition_map(input_name, input_gata_name, input_postnr_name, input_ort_name) {
	//hämtar adressuppgifter och aktuell geoposition
	var gata = $$('input[name="'+input_gata_name+'"]').get('value');
	var postnr = $$('input[name="'+input_postnr_name+'"]').get('value');
	var ort = $$('input[name="'+input_ort_name+'"]').get('value');
	var geopos = $$('input[name="'+input_name+'"]').get('value');

	//sätter ihop adressen
	var adress = '';
	adress += ( gata != '' ) ? ', '+gata : '';
	adress += ( postnr != '' ) ? ', '+postnr : '';
	adress += ( ort != '' ) ? ', '+ort : '';
	adress = ( adress != '' ) ? adress.substring(2) : '';	//plockar borta första 2 tecknen (', ')

	//alert('|'+adress+'|');

	hs.htmlExpand(null, {
		src: base_filename+'?module=index&action=edit_geoposition&input_name='+input_name+'&adress='+adress+'&geopos='+geopos,
		objectType: 'iframe'
	});
}

//------------------------------------------------------------------------------
// Sparar formuläret $(form_id) med AJAX-kall och uppdaterar $(update_div) med svaret
//------------------------------------------------------------------------------
// OBS! FUNKAR INTE MED FILE_UPLOAD!
/*function save_form_ajax(update_div, form_id) {
	myFormRequest = new Form.Request($(form_id), $(update_div));
	myFormRequest.send();

	//returna false så att man kan använda onsubmit="return save_form_ajax(update_div, form_id);" på <form>
	return false;
}*/

//går igenom alla <a class="lightboxed"> och skapar lightboxar
function update_lightboxes()
{
	$$('.lightboxed').each(function(el) {
		el.addEvent('click', function(event){
			return hs.expand(this);
		});
    el.className = 'highslide';
	});

	//hs.updateAnchors();
}





/*--------- Inställningar ----------------------------------------------------*/

/*function delete_setting(config_id) {
	var input_box = confirm('Klicka på OK för att ta bort den här posten');
	if (input_box === true) {
		location.href = base_filename+'?module=index&action=delete_setting&config_id='+config_id;
	}
	return false;
}*/

function save_setting(config_key, el, typ) {

	if ( typ == 'text' ) {
		var config_value = el.value;
	} else if ( typ == 'select' ) {
		var config_value = el.value;
	}

	var el_parent = el.getParent();
	if ( config_key ) {
		ajax_loading();
		var ajax = new Request.HTML({
			url: base_filename+'?module=index&action=save_setting',
			//update: el_parent,
			onSuccess: function (responseTree, responseElements, responseHTML, responseJavaScript) {
				ajax_idle();
				if ( typ == 'text' ) {
					el_parent.innerHTML = responseHTML;
				} else if ( typ == 'select' ) {
					el_parent.innerHTML = '<em>'+el.options[el.selectedIndex].text+'</em>';
				}
			}
		}).post({
			'config_key': config_key,
			'config_value': config_value
		});
	}
	return false;
}

















//------------------------------------------------------------------------------
// GAMLA GREJER (OptiDb)
//------------------------------------------------------------------------------
/*
function load_ajax(my_data) {
	ajax_loading();
	var ajax = new Request.HTML({
		url: base_filename+'?action=ajax',
		update: $('ajax_update'),
		onSuccess: function(response) {
			ajax_idle();
		}
	}).get({
		'data': my_data
	});
}

function edit_val(table_name, col_name, pk_value) {
	ajax_loading();
	var ajax = new Request.HTML({
		url: base_filename+'?action=edit_val',
		update: $('td_'+col_name+'_'+pk_value),
		onSuccess: function(response) {
			ajax_idle();
		}
	}).get({
		'table_name': table_name,
		'col_name': col_name,
		'pk_value': pk_value		
	});
}

function save_val(form_name, col_name, pk_value) {
	ajax_loading();
	var f = $(form_name);
	f.set('send', {onComplete: function(response) {
		ajax_idle();
		$('td_'+col_name+'_'+pk_value).set('html', response);
	}});
	f.send();
}

function load_val(table_name, col_name, pk_value) {
	ajax_loading();
	var ajax = new Request.HTML({
		url: base_filename+'?action=load_val',
		update: $('td_'+col_name+'_'+pk_value),
		onSuccess: function(response) {
			ajax_idle();
		}
	}).get({
		'table_name': table_name,
		'col_name': col_name,
		'pk_value': pk_value		
	});
}

function check_row(span, pk_value) {
	span.toggleClass('check_active');
	$('tr_'+pk_value).toggleClass('checked');
}

function delete_row(table_name, pk_value) {
	var input_box = confirm('Är du säker på att du vill ta bort den här raden?');
	if (input_box === true) {
		ajax_loading();
		var ajax = new Request.HTML({
			url: base_filename+'?action=delete_row',
			update: $('tr_'+pk_value),
			onSuccess: function(response) {
				ajax_idle();
			}
		}).get({
			'table_name': table_name,
			'pk_value': pk_value		
		});
	}
}
*/