<?php
//------------------------------------------------------------------------------
// Jonatan Alvarsson :: User Class 1.2
//------------------------------------------------------------------------------
// Loggar in och håller reda på data om användaren
// Kräver följande MySQL-funktioner: result(), query(), clean()
// För att logga ut: filename.php?logout
//------------------------------------------------------------------------------

class User
{
	//Konfiguration
	private $mysql_table = 'table';						//MySQL-tabellen med användare
	private $mysql_id = 'id';									//MySQL-fältet för id
	private $mysql_username = 'username';			//MySQL-fältet för användarnamn
	private $mysql_password = 'password';			//MySQL-fältet för lösenord
	private $db_encrypted = false;						//true = lösenordet sparas i db krypterat med md5, false = lösenordet sparas i db i klartext
	private $session_name = 'MySession';			//namnet på session
	private $cookie_name = 'MyCookie';				//namnet på cookien
	private $auto_login = true;								//true = en cookie skapas för autologin
	private $auto_login_duration = 31536000;	//hur lång livslängd cookien ska ha (i sekunder) 31536000 sek = 365 dagar
	private $secret_key = 'a78c5bf69b';				//säkerhetscheck - namnet
	private $secret_val = '40d464b954';				//säkerhetscheck - värdet

	//Objektet
	public $name = NULL;
	public $id = NULL;
	public $logged_in = false;
	public $admin = false;
	public $data = array();

	//----------------------------------------------------------------------------
	// Startar session
	//----------------------------------------------------------------------------
	function __construct()
	{
		//skapar/fortsätter sessionen
		session_name($this->session_name);
		session_start();

		//användare som vill logga ut
		if ( isset($_GET['logout']) )
		{
			//tar bort cookien
			setcookie($this->cookie_name, '', time() - 3600);

			$_SESSION['logged_in'] = NULL;

			//dödar sessionen
			session_unset();
			session_destroy();

			$this->die_loginbox();
		}
		//inloggad användare
		elseif ( isset($_SESSION['logged_in']) && $_SESSION[$this->secret_key] === $this->secret_val )
		{
			//$this->data = $_SESSION['user_data'];
			$this->id = $_SESSION['id'];
			$this->name = $_SESSION['username'];
			$this->logged_in = true;
		}
		//användare som försöker logga in
		elseif ( isset($_POST['username']) && isset($_POST['password']) )
		{
			$login_username = clean($_POST['username']);
			$login_password = clean($_POST['password']);

			//kontrollerar användarnamn och lösenord
			$this->try_login($login_username, $login_password);
		}
		//användaren har en cookie (och autologin är tillåtet), ladda in och checka password därifrån
		elseif ( isset($_COOKIE[$this->cookie_name]) && $this->auto_login )
		{
			$cookie_getdata = $_COOKIE[$this->cookie_name];

			//reverse magic_quotes_gpc/magic_quotes_sybase effects on those vars if ON
			if ( get_magic_quotes_gpc() )
			{
				$cookie_getdata = stripslashes($cookie_getdata);
			}
			$cookie_getdata = unserialize($cookie_getdata);

			if ( !empty($cookie_getdata['u']) && !empty($cookie_getdata['p']) )
			{
				//kontrollerar användarnamn och lösenord (md5)
				$this->try_login($cookie_getdata['u'], $cookie_getdata['p'], true);
			}
			else
			{
				//dödar sessionen
				session_unset();
				session_destroy();
				
				//tar bort cookien
				setcookie($this->cookie_name, '', time() - 3600);
				
				$this->die_message('bad cookie');
			}
		}
		//obehörig användare
		else
		{
			$this->die_loginbox();
		}
	}

	//----------------------------------------------------------------------------
	// Loggar in användaren
	//----------------------------------------------------------------------------
	function try_login($login_username, $login_password, $md5_mode = false)
	{
		//kollar användaren mot MySQL-databasen
		$sql = "SELECT $this->mysql_id, $this->mysql_username, $this->mysql_password FROM $this->mysql_table WHERE $this->mysql_username = '$login_username'";
		$result = result(query($sql), false);

		//om md5-läge: skapa en hash av lösenordet från db
		if ( $md5_mode )
		{
			$result[$this->mysql_password] = md5($result[$this->mysql_password]);
		}
		
		//hasha lösenordet från POST med md5 om lösenord lagras hashade i db
		if ( $this->db_encrypted )
		{
			$login_password = md5($login_password);
		}

		//användarnamn och lösenord stämmer!
		if ( count($result) == 3 && $login_username == $result[$this->mysql_username] && $login_password == $result[$this->mysql_password] )
		{
			$this->id = $_SESSION['id'] = $result[$this->mysql_id];
			$this->name = $_SESSION['username'] = $result[$this->mysql_username];
			$this->logged_in = true;

			$_SESSION[$this->secret_key] = $this->secret_val;
			$_SESSION['logged_in'] = 'yes';

			//sparar en cookie med md5(password) + (för autologin!)
			if ( $this->auto_login )
			{
				$encrypted_password = ( $md5_mode ) ? $result[$this->mysql_password] : md5($result[$this->mysql_password]);
				$cookie_setdata = array('u' => $result[$this->mysql_username], 'p' => $encrypted_password);

				setcookie($this->cookie_name, serialize($cookie_setdata), time() + $this->auto_login_duration);
			}
		}
		else
		{
			//dödar sessionen
			session_unset();
			session_destroy();

			//tar bort cookien
			setcookie($this->cookie_name, '', time() - 3600);

			$this->die_message('wrong password');
		}
	}

	//----------------------------------------------------------------------------
	// Dör om inte användaren är inloggad 
	//----------------------------------------------------------------------------
	function require_login()
	{
		if ( $this->logged_in == false )
		{
			$this->die_message('login required');
		}
	}

	//----------------------------------------------------------------------------
	// Dör om inte användaren är administratör
	//----------------------------------------------------------------------------
	function require_admin()
	{
		if ( $this->admin == false )
		{
			$this->die_message('not authorized');
		}
	}

	//----------------------------------------------------------------------------
	// Kollar om användaren är administratör
	//----------------------------------------------------------------------------
	function check_if_admin()
	{
		if ( in_array($this->name, array('admin')) )
		{
			$this->admin = true;
			return true;
		}
		else
		{
			$this->admin = false;
			return false;
		}
	}

	//----------------------------------------------------------------------------
	// Dör med login-box
	//----------------------------------------------------------------------------
	function die_loginbox()
	{
		
		echo '<form name="loginform" method="post" action="'.$_SERVER['PHP_SELF'].'">
<p>Användarnamn:<br /><input name="username" type="text" /></p>
<p>Lösenord:<br /><input type="password" name="password" /></p>
<p><input type="submit" name="button" value="Logga in" /></p>
</form>';

		die();
	}

	//----------------------------------------------------------------------------
	// Dör med ett meddelande
	//----------------------------------------------------------------------------
	function die_message($message)
	{
		die($message);
	}
}

?>