<?php
//------------------------------------------------------------------------------
// Jonatan Alvarsson :: Feedback Class 1.1
//------------------------------------------------------------------------------
// add|get|print		warning|success|neutral
//     get|print		feedback
//
// Warning		red 		Ett fel uppstod
// Success		green		Något genomfördes utan problem
// Neutral		grey		Allmän information
//------------------------------------------------------------------------------

class Feedback
{
	//tre typer av återkopplingar finns 
	public $warning_text = NULL;
	public $success_text = NULL;
	public $neutral_text = NULL;
	
	//lägger till återkoppling
	function addWarning($text) { $this->warning_text .= "<p>$text</p>\n"; }
	function addSuccess($text) { $this->success_text .= "<p>$text</p>\n"; }
	function addNeutral($text) { $this->neutral_text .= "<p>$text</p>\n"; }
	
	//returnerar alla inlagda återkopplingar av en viss typ (eller false om inga hittas)
	function getWarning() { return ( $this->warning_text !== NULL ) ? '<div class="feedback_warning">' . "\n". $this->warning_text . "</div>\n" : false; }
	function getSuccess() { return ( $this->success_text !== NULL ) ? '<div class="feedback_success">' . "\n". $this->success_text . "</div>\n" : false; }
	function getNeutral() { return ( $this->neutral_text !== NULL ) ? '<div class="feedback_neutral">' . "\n". $this->neutral_text . "</div>\n" : false; }

	//lägger till en återkoppling och skriver sedan ut alla återkopplingar av samma typ
	function printWarning($text)
	{
		$this->addWarning($text);
		echo $this->getWarning();
	}
	function printSuccess($text)
	{
		$this->addSuccess($text);
		echo $this->getSuccess();
	}
	function printNeutral($text)
	{
		$this->addNeutral($text);
		echo $this->getNeutral();
	}

	//returnerar alla inlagda återkopplingar (eller false om inga hittas)
	function getFeedback()
	{
		$feedback = $this->getWarning() . $this->getSuccess() . $this->getNeutral();
	
		if ( $feedback !== '' )
		{
			return $feedback;
		}
		else
		{
			return false;
		}
	}

	//skriver ut
	function printFeedback()
	{
		echo $this->getFeedback();
	}
}

?>