<?php
//------------------------------------------------------------------------------
// OptiAdmin :: Text Export
//------------------------------------------------------------------------------
class OptiExport
{
	public $data = '';
	public $filename = '';
	public $error = '';
	public $row_counter = 0;

	function __construct()
	{
		$this->filename = date('ymd_').time().'.txt';
	}

	//skapar en header från en array
	function addHeader($array)
	{
		$c = 0;
		foreach ($array as $value)
		{
			$this->data .= ( $c > 0 ) ? "\t".$value : $value;
			$c++;
		}
		$this->data .= "\r\n";
	}

	//skapar en row från en array
	function addRow($array)
	{
		$c = 0;
		foreach ($array as $value)
		{
			$this->data .= ( $c > 0 ) ? "\t".$value : $value;
			$c++;
		}
		$this->data .= "\r\n";
		$this->row_counter++;
	}

	//skapar och sparar filen
	function createFile($path)
	{
		if ( !$file = fopen($path.$this->filename, 'w') )
		{
			$this->error = 'Kunde inte öppna filen '.$this->filename;
			return false;
		}

    if ( fwrite($file, $this->data) === false )
		{
			$this->error = 'Kunde inte skriva till filen '.$this->filename;
			return false;
    }

		fclose($file);
		return true;
	}
}

//------------------------------------------------------------------------------
// OptiAdmin :: Excel Export (html-tabell)
//------------------------------------------------------------------------------
class ExcelExport extends OptiExport
{
	function __construct()
	{
		$this->filename = date('ymd_').time().'.xls';
	}

	//skapar en tabellheader från en array: <th></th>
	function addHeader($array)
	{
		$this->data .= '<tr>' . "\r\n";
		foreach ($array as $value)
		{
			$this->data .= '<th>'.$value.'</th>' . "\r\n";
		}
		$this->data .= '</tr>' . "\r\n";
	}

	//skapar en tabellrow från en array: <td></td>
	function addRow($array)
	{
		$this->data .= '<tr>' . "\r\n";
		foreach ($array as $value)
		{
			$this->data .= '<td>'.$value.'</td>' . "\r\n";
		}
		$this->data .= '</tr>' . "\r\n";
		$this->row_counter++;
	}

	//skapar och sparar Excel-filen
	function createFile($path)
	{

$xls_content = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="ProgId" content="Excel.Sheet" />
<meta name="Generator" content="Microsoft Excel 11" />
<style>
<!--table
@page{}
-->

td {
	mso-number-format: \@
}

</style>
<!--[if gte mso 9]>
<xml>
	<x:ExcelWorkbook>
		<x:ExcelWorksheets>
			<x:ExcelWorksheet>
				<x:Name>Sheet1</x:Name>
				<x:WorksheetOptions>
					<x:Panes></x:Panes>
				</x:WorksheetOptions>
			</x:ExcelWorksheet>
		</x:ExcelWorksheets>
	</x:ExcelWorkbook>
</xml>
<![endif]-->
</head>

<body>
<table>
';
		$xls_content .= $this->data;
		$xls_content .= '</table>
</body>
</html>';
		$this->data = $xls_content;

		if ( !$file = fopen($path.$this->filename, 'w') )
		{
			$this->error = 'Kunde inte öppna filen '.$this->filename;
			return false;
		}

    if ( fwrite($file, $this->data) === false )
		{
			$this->error = 'Kunde inte skriva till filen '.$this->filename;
			return false;
    }

		fclose($file);
		return true;
	}
}

//------------------------------------------------------------------------------
// OptiAdmin :: CSV Export
//------------------------------------------------------------------------------
class CSVExport extends OptiExport
{
	public $data = array();
	public $delimiter = ',';
	public $enclosure = '"';

	function __construct()
	{
		$this->filename = date('ymd_').time().'.csv';

		//hämtar specialinställningar för csv
		$this->delimiter = ( isset($_POST['csv_delimiter']) ) ? $_POST['csv_delimiter'] : $this->delimiter;
		$this->enclosure = ( isset($_POST['csv_enclosure']) ) ? $_POST['csv_enclosure'] : $this->enclosure;
	}

	//skapar en header från en array
	function addHeader($array)
	{
		$this->data[] = $array;
	}

	//skapar en row från en array
	function addRow($array)
	{
		$this->data[] = $array;
		$this->row_counter++;
	}

	//skapar och sparar filen
	function createFile($path)
	{
		if ( !$file = fopen($path.$this->filename, 'w') )
		{
			$this->error = 'Kunde inte öppna filen '.$this->filename;
			return false;
		}

		foreach ($this->data as $fields)
		{
	    if ( fputcsv($file, $fields, $this->delimiter, $this->enclosure) === false )
			{
				$this->error = 'Kunde inte skriva till filen '.$this->filename;
				return false;
	    }
		}

		fclose($file);
		return true;
	}
}

?>